/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.AbstractVisitor;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.base.SkipCheckChainedInterceptor;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.jmx.annotations.ManagedOperation;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheStoreInterceptor
extends SkipCheckChainedInterceptor {
    private CacheLoaderConfig loaderConfig = null;
    private TransactionManager txMgr = null;
    private HashMap txStores = new HashMap();
    private Map<GlobalTransaction, Set<Fqn>> preparingTxs = new ConcurrentHashMap<GlobalTransaction, Set<Fqn>>();
    private long cacheStores = 0L;
    CacheLoader loader;
    private CacheLoaderManager loaderManager;
    private boolean optimistic;
    private boolean statsEnabled;

    public CacheStoreInterceptor() {
        this.log = LogFactory.getLog(this.getClass());
        this.trace = this.log.isTraceEnabled();
    }

    @Inject
    protected void init(CacheLoaderManager loaderManager, TransactionManager txManager, CacheLoaderConfig clConfig) {
        this.loaderManager = loaderManager;
        this.loaderConfig = clConfig;
        this.txMgr = txManager;
    }

    @Start
    protected void start() {
        this.loader = this.loaderManager.getCacheLoader();
        this.optimistic = this.configuration.getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC;
        this.setStatisticsEnabled(this.configuration.getExposeManagementStatistics());
    }

    @Override
    public boolean skipInterception(InvocationContext ctx, VisitableCommand command) {
        if (!ctx.isOriginLocal() && this.loaderConfig.isShared() || ctx.getOptionOverrides().isSuppressPersistence()) {
            if (this.trace) {
                this.log.trace((Object)"Passing up method call and bypassing this interceptor since the cache loader is shared and this call originated remotely.");
            }
            return true;
        }
        return false;
    }

    @Override
    protected Object handleCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.inTransaction()) {
            if (ctx.getTransactionContext().hasAnyModifications()) {
                Set<Fqn> affectedFqns;
                GlobalTransaction gtx = command.getGlobalTransaction();
                if (this.trace) {
                    this.log.trace((Object)("Calling loader.commit() for gtx " + gtx));
                }
                try {
                    this.loader.commit(gtx);
                }
                catch (Throwable t) {
                    this.preparingTxs.remove(gtx);
                    throw t;
                }
                if (this.getStatisticsEnabled()) {
                    Integer puts = (Integer)this.txStores.get(gtx);
                    if (puts != null) {
                        this.cacheStores += (long)puts.intValue();
                    }
                    this.txStores.remove(gtx);
                }
                Object returnValue = this.invokeNextInterceptor(ctx, command);
                if (this.optimistic && (affectedFqns = this.preparingTxs.remove(gtx)) != null && !affectedFqns.isEmpty()) {
                    this.storeInternalState(affectedFqns, ctx);
                }
                return returnValue;
            }
            if (this.trace) {
                this.log.trace((Object)"Commit called with no modifications; ignoring.");
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected Object handleRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.inTransaction()) {
            if (this.trace) {
                this.log.trace((Object)"transactional so don't put stuff in the cloader yet.");
            }
            if (ctx.getTransactionContext().hasAnyModifications()) {
                GlobalTransaction gtx = command.getGlobalTransaction();
                if (this.preparingTxs.containsKey(gtx)) {
                    this.preparingTxs.remove(gtx);
                    this.loader.rollback(gtx);
                }
                if (this.getStatisticsEnabled()) {
                    this.txStores.remove(gtx);
                }
            } else if (this.trace) {
                this.log.trace((Object)"Rollback called with no modifications; ignoring.");
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected Object handleOptimisticPrepareCommand(InvocationContext ctx, OptimisticPrepareCommand command) throws Throwable {
        return this.handlePrepareCommand(ctx, command);
    }

    @Override
    protected Object handlePrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        if (this.inTransaction()) {
            if (this.trace) {
                this.log.trace((Object)"transactional so don't put stuff in the cloader yet.");
            }
            this.prepareCacheLoader(command.getGlobalTransaction(), ctx.getTransactionContext(), command.isOnePhaseCommit());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected Object handleRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        if (!this.inTransaction()) {
            this.loader.remove(command.getFqn());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected Object handleRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        if (!this.inTransaction()) {
            Object returnValue = this.loader.remove(command.getFqn(), command.getKey());
            this.invokeNextInterceptor(ctx, command);
            return returnValue;
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected Object handleRemoveDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        if (!this.inTransaction()) {
            this.loader.removeData(command.getFqn());
            NodeSPI n = ctx.lookUpNode(command.getFqn());
            if (n != null) {
                n.setDataLoaded(true);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected Object handleMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.inTransaction()) {
            return returnValue;
        }
        Fqn<Object> newNodeFqn = Fqn.fromRelativeElements(command.getTo(), command.getFqn().getLastElement());
        this.recursiveMove(command.getFqn(), newNodeFqn);
        this.loader.remove(command.getFqn());
        return returnValue;
    }

    @Override
    protected Object handlePutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.inTransaction()) {
            return returnValue;
        }
        this.storeStateForPutDataMap(command.getFqn(), ctx);
        if (this.getStatisticsEnabled()) {
            ++this.cacheStores;
        }
        return returnValue;
    }

    protected void storeStateForPutDataMap(Fqn f, InvocationContext ctx) throws Exception {
        this.loader.put(f, ctx.lookUpNode(f).getDelegationTarget().getData());
    }

    @Override
    protected Object handlePutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.inTransaction()) {
            return returnValue;
        }
        returnValue = this.loader.put(command.getFqn(), command.getKey(), command.getValue());
        if (this.getStatisticsEnabled()) {
            ++this.cacheStores;
        }
        return returnValue;
    }

    @Override
    protected Object handlePutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.handlePutKeyValueCommand(ctx, command);
    }

    private boolean inTransaction() throws SystemException {
        return this.txMgr != null && this.txMgr.getTransaction() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeInternalState(Set<Fqn> affectedFqns, InvocationContext ctx) throws Exception {
        if (this.configuration.getNodeLockingScheme().isVersionedScheme()) {
            Transaction tx = this.txMgr.suspend();
            try {
                for (Fqn f : affectedFqns) {
                    NodeSPI n = ctx.lookUpNode(f);
                    if (n == null || n.isDeleted()) continue;
                    Map internalState = n.getInternalState(false);
                    this.loader.put(f, internalState);
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.txMgr.resume(tx);
                throw throwable;
            }
            this.txMgr.resume(tx);
            {
            }
        }
    }

    private void recursiveMove(Fqn fqn, Fqn newFqn) throws Exception {
        this.loader.put(newFqn, this.loader.get(fqn));
        Set<?> childrenNames = this.loader.getChildrenNames(fqn);
        if (childrenNames != null) {
            for (Object child : childrenNames) {
                this.recursiveMove(Fqn.fromRelativeElements(fqn, child), Fqn.fromRelativeElements(newFqn, child));
            }
        }
    }

    private void prepareCacheLoader(GlobalTransaction gtx, TransactionContext transactionContext, boolean onePhase) throws Throwable {
        if (transactionContext == null) {
            throw new Exception("transactionContext for transaction " + gtx + " not found in transaction table");
        }
        List<WriteCommand> modifications = transactionContext.getModifications();
        if (modifications.size() == 0) {
            if (this.trace) {
                this.log.trace((Object)"Transaction has not logged any modifications!");
            }
            return;
        }
        if (this.trace) {
            this.log.trace((Object)("Cache loader modification list: " + modifications));
        }
        StoreModificationsBuilder modsBuilder = new StoreModificationsBuilder(this.getStatisticsEnabled());
        for (WriteCommand cacheCommand : modifications) {
            cacheCommand.acceptVisitor(null, modsBuilder);
        }
        if (this.trace) {
            this.log.trace((Object)("Converted method calls to cache loader modifications.  List size: " + modsBuilder.modifications.size()));
        }
        if (modsBuilder.modifications.size() > 0) {
            this.loader.prepare(gtx, modsBuilder.modifications, onePhase);
            this.preparingTxs.put(gtx, modsBuilder.affectedFqns);
            if (this.getStatisticsEnabled() && modsBuilder.putCount > 0) {
                this.txStores.put(gtx, modsBuilder.putCount);
            }
        }
    }

    @ManagedOperation
    public void resetStatistics() {
        this.cacheStores = 0L;
    }

    @ManagedOperation
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("CacheLoaderStores", this.cacheStores);
        return retval;
    }

    @ManagedAttribute
    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    @ManagedAttribute
    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    @ManagedAttribute(description="number of cache loader stores")
    public long getCacheLoaderStores() {
        return this.cacheStores;
    }

    public static class StoreModificationsBuilder
    extends AbstractVisitor {
        boolean generateStatistics;
        int putCount;
        Set<Fqn> affectedFqns = new HashSet<Fqn>();
        List<Modification> modifications = new ArrayList<Modification>();

        public StoreModificationsBuilder(boolean generateStatistics) {
            this.generateStatistics = generateStatistics;
        }

        public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
            if (this.generateStatistics) {
                ++this.putCount;
            }
            this.modifications.add(new Modification(Modification.ModificationType.PUT_DATA, command.getFqn(), command.getData()));
            this.affectedFqns.add(command.getFqn());
            return null;
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (this.generateStatistics) {
                ++this.putCount;
            }
            this.modifications.add(new Modification(Modification.ModificationType.PUT_KEY_VALUE, command.getFqn(), command.getKey(), command.getValue()));
            this.affectedFqns.add(command.getFqn());
            return null;
        }

        public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
            this.modifications.add(new Modification(Modification.ModificationType.REMOVE_KEY_VALUE, command.getFqn(), command.getKey()));
            this.affectedFqns.add(command.getFqn());
            return null;
        }

        public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
            this.modifications.add(new Modification(Modification.ModificationType.REMOVE_DATA, command.getFqn()));
            this.affectedFqns.add(command.getFqn());
            return null;
        }

        public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
            this.modifications.add(new Modification(Modification.ModificationType.REMOVE_NODE, command.getFqn()));
            this.affectedFqns.add(command.getFqn());
            return null;
        }

        public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
            Fqn moveFrom = command.getFqn();
            this.affectedFqns.add(command.getFqn());
            this.affectedFqns.add(moveFrom);
            Modification mod = new Modification(Modification.ModificationType.MOVE, moveFrom, command.getTo());
            this.modifications.add(mod);
            return null;
        }
    }
}

