/*
 * JBoss, Home of Professional Open Source
 * Copyright ${year}, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.cache.search;

import org.jboss.cache.CacheException;

/**
 * Thrown when an invalid Fqn is passed into {@link org.jboss.cache.search.Transformer#generateId(org.jboss.cache.Fqn, String)}
 * <p />
 * @author Navin Surtani (<a href="mailto:nsurtani@redhat.com">nsurtani@redhat.com</a>)
 */
public class InvalidFqnException extends CacheException
{
   public InvalidFqnException()
   {
   }

   public InvalidFqnException(String s)
   {
      super(s);
   }

   public InvalidFqnException(String s, Throwable throwable)
   {
      super(s, throwable);
   }

   public InvalidFqnException(Throwable throwable)
   {
      super(throwable);
   }
}
