package org.jboss.cache.search.blackbox;

import org.testng.annotations.Test;
import org.jboss.cache.search.test.BrokenProvided;
import org.jboss.cache.search.test.BrokenDocumentId;
import org.jboss.cache.search.SearchableCache;
import org.jboss.cache.search.SearchableCacheFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;

/**
 * This test is to try and create a searchable cache without the proper annotations used.
 *
 * @author Navin Surtani (<a href="mailto:nsurtani@redhat.com">nsurtani@redhat.com</a>)
 */
@Test (groups = "functional")
public class BrokenAnnotationTest
{
   @Test (expectedExceptions = IllegalArgumentException.class)
   public void testProvided()
   {
      BrokenProvided provided = new BrokenProvided();
      provided.setBoth("Cat", 5);

      Cache cache = new DefaultCacheFactory().createCache();

      SearchableCache searchable = new SearchableCacheFactory().createSearchableCache(cache, BrokenProvided.class);


   }

   @Test (expectedExceptions = IllegalArgumentException.class)
   public void testDocumentId()
   {
      BrokenDocumentId provided = new BrokenDocumentId();
      provided.setBoth("Cat", 5);

      Cache cache = new DefaultCacheFactory().createCache();

      SearchableCache searchable = new SearchableCacheFactory().createSearchableCache(cache, BrokenProvided.class);



   }

}
