/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import org.jboss.cache.config.LegacyConfigurationException;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class XmlParserBase {
    protected int getInt(String intStr) {
        return Integer.parseInt(intStr);
    }

    protected long getLong(String longStr) {
        return Long.parseLong(longStr);
    }

    protected boolean getBoolean(String str) {
        return str == null ? false : Boolean.valueOf(str);
    }

    protected boolean existsAttribute(String attrValue) {
        return attrValue != null && attrValue.length() > 0;
    }

    protected Element getSingleElement(String namespace, String elementName, Element parent) {
        NodeList nodeList = parent.getElementsByTagNameNS(namespace, elementName);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    protected Element getSingleElementInCoreNS(String elementName, Element parent) {
        return this.getSingleElement("urn:jboss:jbosscache-core:config:3.0", elementName, parent);
    }

    protected String getAttributeValue(Element element, String attrName) {
        if (element == null || attrName == null) {
            return null;
        }
        String value = element.getAttribute(attrName);
        return value == null ? null : StringPropertyReplacer.replaceProperties((String)value);
    }

    protected void assertNotLegacyElement(Element e) {
        String name = e.getNodeName();
        if ("config".equals(name)) {
            throw new LegacyConfigurationException("Legacy element encountered when using parser " + this.getClass().getSimpleName());
        }
    }
}

