/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.concurrent.locks;

import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import net.jcip.annotations.ThreadSafe;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.util.concurrent.locks.LockContainer;
import org.jboss.cache.util.concurrent.locks.OwnableReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class OwnableReentrantLockContainer<E>
extends LockContainer<E> {
    OwnableReentrantLock[] sharedLocks;
    InvocationContextContainer icc;

    public OwnableReentrantLockContainer(int concurrencyLevel, InvocationContextContainer icc) {
        this.icc = icc;
        this.initLocks(this.calculateNumberOfSegments(concurrencyLevel));
    }

    @Override
    protected void initLocks(int numLocks) {
        this.sharedLocks = new OwnableReentrantLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.sharedLocks[i] = new OwnableReentrantLock(this.icc);
        }
    }

    @Override
    public final OwnableReentrantLock getLock(E object) {
        return this.sharedLocks[this.hashToIndex(object)];
    }

    @Override
    public final boolean ownsLock(E object, Object owner) {
        Lock lock = this.getLock((Object)object);
        return owner.equals(((OwnableReentrantLock)lock).getOwner());
    }

    @Override
    public final boolean isLocked(E object) {
        Lock lock = this.getLock((Object)object);
        return ((OwnableReentrantLock)lock).isLocked();
    }

    @Override
    public final int getNumLocksHeld() {
        int i = 0;
        for (OwnableReentrantLock l : this.sharedLocks) {
            if (!l.isLocked()) continue;
            ++i;
        }
        return i;
    }

    public String toString() {
        return "OwnableReentrantLockContainer{sharedLocks=" + (this.sharedLocks == null ? null : Arrays.asList(this.sharedLocks)) + '}';
    }

    @Override
    public void reset() {
        this.initLocks(this.sharedLocks.length);
    }

    @Override
    public int size() {
        return this.sharedLocks.length;
    }
}

