/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.api.annotations.MCAnnotations;
import org.jboss.kernel.plugins.annotations.AnnotationPluginFilter;
import org.jboss.kernel.plugins.annotations.MetaDataAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.MethodAnnotationPluginFilter;
import org.jboss.kernel.plugins.annotations.PropertyAnnotationPluginFilter;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonAnnotationAdapter<T extends MetaDataAnnotationPlugin<?, ?>, U> {
    protected Logger log = Logger.getLogger(this.getClass());
    private final Map<ElementType, Set<T>> pluginsMap = new HashMap<ElementType, Set<T>>();
    private static final AnnotationPluginFilter PROPERTY_FILTER = new PropertyAnnotationPluginFilter();
    private static final AnnotationPluginFilter METHOD_FILTER = new MethodAnnotationPluginFilter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationPlugin(T plugin) {
        Set<ElementType> supported;
        if (plugin == null) {
            throw new IllegalArgumentException("Null plugin.");
        }
        Class annotation = plugin.getAnnotation();
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation class: " + plugin);
        }
        if (annotation.getAnnotation(Target.class) == null) {
            this.log.warn((Object)("Annotation " + annotation + " missing @Target annotation!"));
        }
        if (annotation.getAnnotation(Retention.class) == null) {
            this.log.warn((Object)("Annotation " + annotation + " missing @Retention annotation!"));
        }
        if ((supported = plugin.getSupportedTypes()) == null || supported.isEmpty()) {
            throw new IllegalArgumentException("Null or empty support types: " + plugin);
        }
        Map<ElementType, Set<T>> map = this.pluginsMap;
        synchronized (map) {
            for (ElementType type : supported) {
                Set<T> plugins = this.pluginsMap.get((Object)type);
                if (plugins == null) {
                    plugins = new HashSet<T>();
                    this.pluginsMap.put(type, plugins);
                }
                plugins.add(plugin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationPlugin(T plugin) {
        if (plugin == null) {
            return;
        }
        Set<ElementType> supported = plugin.getSupportedTypes();
        if (supported == null || supported.isEmpty()) {
            throw new IllegalArgumentException("Null or empty support types: " + plugin);
        }
        Map<ElementType, Set<T>> map = this.pluginsMap;
        synchronized (map) {
            for (ElementType type : supported) {
                Set<T> plugins = this.pluginsMap.get((Object)type);
                if (plugins == null) continue;
                plugins.remove(plugin);
                if (!plugins.isEmpty()) continue;
                this.pluginsMap.remove((Object)type);
            }
        }
    }

    protected abstract void applyPlugin(T var1, AnnotatedInfo var2, MetaData var3, U var4) throws Throwable;

    protected abstract void cleanPlugin(T var1, AnnotatedInfo var2, MetaData var3, U var4) throws Throwable;

    protected abstract Object getName(U var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<T> getPlugins(ElementType type, AnnotationPluginFilter filter, Collection<Class<? extends Annotation>> annotationClasses) {
        ArrayList<MetaDataAnnotationPlugin> result;
        Set<T> plugins;
        Map<ElementType, Set<T>> map = this.pluginsMap;
        synchronized (map) {
            plugins = this.pluginsMap.get((Object)type);
        }
        if (plugins == null || plugins.isEmpty()) {
            return Collections.emptySet();
        }
        if (filter != null) {
            result = new ArrayList<MetaDataAnnotationPlugin>();
            for (MetaDataAnnotationPlugin plugin : plugins) {
                if (!filter.accept(plugin) || annotationClasses != null && !annotationClasses.contains(plugin.getAnnotation())) continue;
                result.add(plugin);
            }
            return result;
        }
        if (annotationClasses != null) {
            result = new ArrayList();
            for (MetaDataAnnotationPlugin plugin : plugins) {
                if (!annotationClasses.contains(plugin.getAnnotation())) continue;
                result.add(plugin);
            }
            return result;
        }
        return plugins;
    }

    protected void handleAnnotations(BeanInfo info, MetaData retrieval, U handle, boolean isApplyPhase) throws Throwable {
        MethodInfo[] staticMethods;
        MCAnnotations annotations;
        if (info == null) {
            throw new IllegalArgumentException("Null bean info.");
        }
        if (retrieval == null) {
            throw new IllegalArgumentException("Null metadata.");
        }
        if (handle == null) {
            throw new IllegalArgumentException("Null handle.");
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)(this.getName(handle) + " apply annotations"));
        }
        if ((annotations = (MCAnnotations)retrieval.getAnnotation(MCAnnotations.class)) != null && (annotations.ignore() || annotations.value().length == 0)) {
            if (trace) {
                this.log.trace((Object)("Ignoring annotations lookup: " + annotations));
            }
            return;
        }
        List<Class<? extends Annotation>> annotationClasses = annotations != null ? Arrays.asList(annotations.value()) : null;
        ClassInfo classInfo = info.getClassInfo();
        for (MetaDataAnnotationPlugin plugin : this.getPlugins(ElementType.TYPE, null, annotationClasses)) {
            if (isApplyPhase) {
                this.applyPlugin(plugin, (AnnotatedInfo)classInfo, retrieval, handle);
                continue;
            }
            this.cleanPlugin(plugin, (AnnotatedInfo)classInfo, retrieval, handle);
        }
        Set constructors = info.getConstructors();
        if (constructors != null && !constructors.isEmpty()) {
            for (ConstructorInfo ci : constructors) {
                ConstructorSignature cis = new ConstructorSignature(ci);
                MetaData cmdr = retrieval.getComponentMetaData((Signature)cis);
                if (cmdr != null) {
                    for (MetaDataAnnotationPlugin plugin : this.getPlugins(ElementType.CONSTRUCTOR, null, annotationClasses)) {
                        if (isApplyPhase) {
                            this.applyPlugin(plugin, (AnnotatedInfo)ci, cmdr, handle);
                            continue;
                        }
                        this.cleanPlugin(plugin, (AnnotatedInfo)ci, cmdr, handle);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + ci));
            }
        } else if (trace) {
            this.log.trace((Object)"No constructors");
        }
        HashSet<MethodInfo> visitedMethods = new HashSet<MethodInfo>();
        Set properties = info.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (PropertyInfo pi : properties) {
                FieldInfo field = pi.getFieldInfo();
                if (field != null) {
                    FieldSignature sis = new FieldSignature(field);
                    MetaData cmdr = retrieval.getComponentMetaData((Signature)sis);
                    if (cmdr != null) {
                        for (MetaDataAnnotationPlugin plugin : this.getPlugins(ElementType.FIELD, null, annotationClasses)) {
                            if (isApplyPhase) {
                                this.applyPlugin(plugin, (AnnotatedInfo)field, cmdr, handle);
                                continue;
                            }
                            this.cleanPlugin(plugin, (AnnotatedInfo)field, cmdr, handle);
                        }
                    } else if (trace) {
                        this.log.trace((Object)("No annotations for field " + field.getName()));
                    }
                }
                this.handleMethod(retrieval, handle, isApplyPhase, trace, visitedMethods, pi, pi.getSetter(), "setter", annotationClasses);
                this.handleMethod(retrieval, handle, isApplyPhase, trace, visitedMethods, pi, pi.getGetter(), "getter", annotationClasses);
            }
        } else if (trace) {
            this.log.trace((Object)"No properties");
        }
        TypeInfoFactory tif = classInfo.getTypeInfoFactory();
        TypeInfo objectTI = tif.getTypeInfo(Object.class);
        Iterable<T> methodPlugins = null;
        Set methods = info.getMethods();
        if (methods != null && !methods.isEmpty()) {
            for (MethodInfo mi : methods) {
                ClassInfo declaringCI = mi.getDeclaringClass();
                if (declaringCI == objectTI || visitedMethods.contains(mi)) continue;
                MethodSignature mis = new MethodSignature(mi);
                MetaData cmdr = retrieval.getComponentMetaData((Signature)mis);
                if (cmdr != null) {
                    methodPlugins = this.getPlugins(ElementType.METHOD, METHOD_FILTER, annotationClasses);
                    for (MetaDataAnnotationPlugin plugin : methodPlugins) {
                        if (isApplyPhase) {
                            this.applyPlugin(plugin, (AnnotatedInfo)mi, cmdr, handle);
                            continue;
                        }
                        this.cleanPlugin(plugin, (AnnotatedInfo)mi, cmdr, handle);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + mi));
            }
        } else if (trace) {
            this.log.trace((Object)"No methods");
        }
        if ((staticMethods = this.getStaticMethods(classInfo)) != null && staticMethods.length != 0) {
            for (MethodInfo smi : staticMethods) {
                if (!smi.isStatic() || !smi.isPublic()) continue;
                MethodSignature mis = new MethodSignature(smi);
                MetaData cmdr = retrieval.getComponentMetaData((Signature)mis);
                if (cmdr != null) {
                    if (methodPlugins == null) {
                        methodPlugins = this.getPlugins(ElementType.METHOD, METHOD_FILTER, annotationClasses);
                    }
                    for (MetaDataAnnotationPlugin plugin : methodPlugins) {
                        if (isApplyPhase) {
                            this.applyPlugin(plugin, (AnnotatedInfo)smi, cmdr, handle);
                            continue;
                        }
                        this.cleanPlugin(plugin, (AnnotatedInfo)smi, cmdr, handle);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + smi));
            }
        } else if (trace) {
            this.log.trace((Object)"No static methods");
        }
    }

    protected void handleMethod(MetaData retrieval, U handle, boolean isApplyPhase, boolean trace, Set<MethodInfo> visitedMethods, PropertyInfo pi, MethodInfo method, String type, Collection<Class<? extends Annotation>> annotationClasses) throws Throwable {
        if (method == null) {
            return;
        }
        visitedMethods.add(method);
        MethodSignature sis = new MethodSignature(method);
        MetaData cmdr = retrieval.getComponentMetaData((Signature)sis);
        if (cmdr != null) {
            for (MetaDataAnnotationPlugin plugin : this.getPlugins(ElementType.METHOD, PROPERTY_FILTER, annotationClasses)) {
                if (isApplyPhase) {
                    this.applyPlugin(plugin, (AnnotatedInfo)pi, cmdr, handle);
                    continue;
                }
                this.cleanPlugin(plugin, (AnnotatedInfo)pi, cmdr, handle);
            }
        } else if (trace) {
            this.log.trace((Object)("No annotations for " + type + ": " + pi.getName()));
        }
    }

    protected MethodInfo[] getStaticMethods(ClassInfo classInfo) {
        return classInfo.getDeclaredMethods();
    }
}

