/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.RequirementDependencyItem;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoadingSpace {
    private static final Logger log = Logger.getLogger(ClassLoadingSpace.class);
    private static boolean trace = log.isTraceEnabled();
    private Map<Module, Module> modules = new ConcurrentHashMap<Module, Module>();
    private Map<String, Module> modulesByPackage = new ConcurrentHashMap<String, Module>();
    private Map<Module, List<RequirementDependencyItem>> requirements = new ConcurrentHashMap<Module, List<RequirementDependencyItem>>();

    public Set<Module> getModules() {
        return Collections.unmodifiableSet(this.modules.keySet());
    }

    synchronized void joinAndResolve(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        trace = log.isTraceEnabled();
        this.join(module);
        try {
            this.resolve(module);
        }
        catch (Throwable t) {
            this.split(module);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(this.modules + " could not join " + this, t);
        }
    }

    synchronized void joinAndResolve(Set<Module> modules) {
        if (modules == null) {
            throw new IllegalArgumentException("Null modules");
        }
        HashMap<Module, ClassLoadingSpace> previous = new HashMap<Module, ClassLoadingSpace>();
        try {
            for (Module module : modules) {
                ClassLoadingSpace space = module.getClassLoadingSpace();
                this.join(module);
                previous.put(module, space);
                this.resolve(module);
            }
        }
        catch (Throwable t) {
            for (Map.Entry entry : previous.entrySet()) {
                Module module = (Module)entry.getKey();
                ClassLoadingSpace space = (ClassLoadingSpace)entry.getValue();
                this.split(module);
                try {
                    space.join(module);
                }
                catch (Throwable t2) {
                    log.error((Object)(module + " could not join " + space), t);
                    throw new RuntimeException("BUG: " + module + " could not rejoin " + space + " after failing to join " + this, t2);
                }
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(modules + " could not join " + this, t);
        }
    }

    void joinAndResolve(ClassLoadingSpace space) {
        int otherSize;
        if (space == null) {
            throw new IllegalArgumentException("Null space");
        }
        if (space == this) {
            return;
        }
        int ourSize = this.getModules().size();
        if (ourSize >= (otherSize = space.getModules().size())) {
            this.joinAndResolve(space.getModules());
        } else {
            space.joinAndResolve(this.getModules());
        }
    }

    synchronized void split(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        ClassLoadingSpace other = module.getClassLoadingSpace();
        if (other != this) {
            throw new IllegalStateException(module + " has the wrong classloading space: expected=" + this + " was " + other);
        }
        this.unjoin(module);
        this.unresolve(module);
    }

    synchronized void join(Module module) {
        List<String> exportedPackages;
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        ClassLoadingSpace other = module.getClassLoadingSpace();
        if (other == this) {
            return;
        }
        if (trace) {
            log.trace((Object)(module + " joining " + this));
        }
        if ((exportedPackages = module.determinePackageNames(false)) != null && !exportedPackages.isEmpty()) {
            for (String exportedPackage : exportedPackages) {
                Module otherModule = this.modulesByPackage.get(exportedPackage);
                if (otherModule == null) continue;
                throw new IllegalStateException(module + " cannot be added because it is exports package " + exportedPackage + " which conflicts with " + otherModule);
            }
        }
        List<RequirementDependencyItem> moduleDependencies = module.getDependencies();
        if (!this.requirements.isEmpty() && moduleDependencies != null && !moduleDependencies.isEmpty()) {
            for (RequirementDependencyItem dependency : moduleDependencies) {
                Requirement requirement = dependency.getRequirement();
                for (Map.Entry<Module, List<RequirementDependencyItem>> entry : this.requirements.entrySet()) {
                    Module otherModule = entry.getKey();
                    List<RequirementDependencyItem> dependencies = entry.getValue();
                    for (RequirementDependencyItem otherDependency : dependencies) {
                        Requirement otherRequirement = otherDependency.getRequirement();
                        if (requirement.isConsistent(otherRequirement)) continue;
                        throw new IllegalStateException(module + " has a requirement " + requirement + " which is inconsistent with " + otherRequirement + " from " + otherModule);
                    }
                }
            }
        }
        if (exportedPackages != null && !exportedPackages.isEmpty()) {
            for (String exportedPackage : exportedPackages) {
                this.modulesByPackage.put(exportedPackage, module);
            }
        }
        if (moduleDependencies != null && !moduleDependencies.isEmpty()) {
            this.requirements.put(module, moduleDependencies);
        }
        if (other != null) {
            other.split(module);
        }
        this.modules.put(module, module);
        module.setClassLoadingSpace(this);
    }

    private void unjoin(Module module) {
        List<String> packageNames;
        if (trace) {
            log.trace((Object)(module + " unjoining " + this));
        }
        if ((packageNames = module.determinePackageNames(false)) != null) {
            for (String packageName : packageNames) {
                Module removed = this.modulesByPackage.remove(packageName);
                if (removed == module) continue;
                throw new IllegalStateException("BUG: Removed module " + removed + " for package " + packageName + " is not the expected module: " + module);
            }
        }
        this.requirements.remove(module);
        this.modules.remove(module);
        module.setClassLoadingSpace(null);
    }

    synchronized void resolve(Module module) {
        List<RequirementDependencyItem> moduleDependencies;
        if (trace) {
            log.trace((Object)(module + " resolving " + this));
        }
        if ((moduleDependencies = this.requirements.get(module)) != null) {
            for (RequirementDependencyItem dependency : moduleDependencies) {
                ClassLoadingSpace space;
                Module otherModule;
                if (dependency.isResolved() || (otherModule = module.resolveModule(dependency, false)) == null || this == (space = otherModule.getClassLoadingSpace())) continue;
                space.joinAndResolve(this);
            }
        }
    }

    private void unresolve(Module module) {
        if (trace) {
            log.trace((Object)(module + " unresolving " + this));
        }
    }
}

