/*
 * JBoss, a division of Red Hat
 * Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ha.client.loadbalance.aop;

import java.util.List;

import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.remoting.ClusterConstants;
import org.jboss.ha.client.loadbalance.AopLoadBalancePolicy;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;



/**
 * Extends the "sticky session" behavior of {@link FirstAvailable} by caching 
 * the favored target in the {@link FamilyClusterInfo}, thus allowing different 
 * proxies for the same family to use the same favored target.
 * <p>
 * See {@link FirstAvailable} for the basic behavior.
 * </p>
 * 
 * @see org.jboss.ha.framework.interfaces.FamilyClusterInfo#getObject()
 *
 * @author Brian Stansberry
 * 
 * @version $Revision: 57642 $
 */
public class FirstAvailableIdenticalAllProxies 
extends org.jboss.ha.client.loadbalance.FirstAvailableIdenticalAllProxies 
implements AopLoadBalancePolicy
{
   // Constants -----------------------------------------------------
   private static final long serialVersionUID = 2910756623413400467L;

   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------
       
   // Public --------------------------------------------------------

   public Object chooseTarget (FamilyClusterInfo clusterFamily, Invocation invocation)
   {
      Object target = clusterFamily.getObject ();
      List targets = clusterFamily.getTargets ();

      if (targets.size () == 0)
         return null;
      
      if (target != null && targets.contains (target) )
      {
         return target;
      }
      else
      {
         target = electTarget(targets, invocation);
         clusterFamily.setObject (target);
         return target;
      }   
   }

   private Object electTarget(List targets, Invocation invocation)
   {
      Object target = invocation.getMetaData(ClusterConstants.CLUSTERED_REMOTING, ClusterConstants.HA_TARGET);
      if (target == null || !targets.contains(target))
         target = electTarget(targets);
      return target;
   }

}
