/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.DispatcherConnectException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.remoting.ClusterConstants;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.ha.client.loadbalance.AopLoadBalancePolicy;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextUtil;

public class ClusterChooserInterceptor
implements Interceptor,
ClusterConstants,
Serializable {
    private static final long serialVersionUID = -8666382019058421135L;
    private static Logger log = Logger.getLogger(ClusterChooserInterceptor.class);
    private static boolean trace = log.isTraceEnabled();
    public static final ClusterChooserInterceptor singleton = new ClusterChooserInterceptor();
    private static final Map<Object, InvokerLocator> txStickyTargets = Collections.synchronizedMap(new WeakHashMap());

    public String getName() {
        return "ClusterChooserInterceptor";
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Invocation invocation) throws Throwable {
        StringBuilder sb = new StringBuilder();
        try {
            Object object;
            sb.append("-----------------------[ClusterChooserInterceptor]----------------------------\n");
            LoadBalancePolicy lb = (LoadBalancePolicy)invocation.getMetaData((Object)"CLUSTERED_REMOTING", (Object)"LOADBALANCE_POLICY");
            FamilyWrapper family = (FamilyWrapper)invocation.getMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY_WRAPPER");
            int failoverCounter = 0;
            String familyName = family.get().getFamilyName();
            invocation.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY", (Object)familyName, PayloadKey.AS_IS);
            InvokerLocator target = null;
            InvokerLocator txStickyTarget = null;
            boolean supportsTxStickiness = family.isTxStickinessSupported();
            sb.append("---------------------------------------------------\n");
            sb.append("Support stickines: " + supportsTxStickiness + "\n");
            sb.append("Targets: " + family.get().getTargets() + "\n");
            sb.append("---------------------------------------------------\n");
            if (supportsTxStickiness && (object = this.getTransactionPropagationContext()) != null) {
                txStickyTarget = txStickyTargets.get(object);
                sb.append("---------------------------------------------------\n");
                sb.append("Sticky target: " + txStickyTarget + "\n");
                sb.append("---------------------------------------------------\n");
                if (txStickyTarget != null) {
                    if (!family.get().getTargets().contains(txStickyTarget)) throw new RuntimeException("Current transaction is stuck to " + txStickyTarget + " which is no longer available.  Halting invocation.");
                    if (trace) {
                        log.trace((Object)("Using transaction sticky target: " + txStickyTarget));
                    }
                    target = txStickyTarget;
                }
            }
            if (target == null) {
                if (lb instanceof AopLoadBalancePolicy) {
                    target = (InvokerLocator)((AopLoadBalancePolicy)lb).chooseTarget(family.get(), invocation);
                    sb.append("---------------------------------------------------\n");
                    sb.append("Choose target - AOP: " + lb + "\n");
                    sb.append("---------------------------------------------------\n");
                } else {
                    target = (InvokerLocator)lb.chooseTarget(family.get());
                    sb.append("---------------------------------------------------\n");
                    sb.append("Choose target: " + lb);
                    sb.append("---------------------------------------------------\n");
                }
            }
            sb.append("---------------------------------------------------\n");
            sb.append("Target: " + target + "\n");
            sb.append("---------------------------------------------------\n");
            Object var10_11 = null;
            boolean failoverAuthorized = true;
            while (target != null && failoverAuthorized) {
                invocation.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"FAILOVER_COUNTER", (Object)new Integer(failoverCounter), PayloadKey.AS_IS);
                invocation.getMetaData().addMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR", (Object)target, PayloadKey.AS_IS);
                invocation.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_VIEW_ID", (Object)new Long(family.get().getCurrentViewId()), PayloadKey.AS_IS);
                boolean definitivlyRemoveNodeOnFailure = true;
                Object var10_13 = null;
                try {
                    sb.append("---------------------------------------------------\n");
                    sb.append("InvokeNext: " + target + " > " + failoverAuthorized + "\n");
                    sb.append("---------------------------------------------------\n");
                    Object rsp = invocation.invokeNext();
                    List newReplicants = (List)invocation.getResponseAttachment((Object)"replicants");
                    if (newReplicants != null) {
                        long newViewId = (Long)invocation.getResponseAttachment((Object)"viewId");
                        family.get().updateClusterInfo(newReplicants, newViewId);
                    }
                    if (txStickyTarget == null && this.invocationHasReachedAServer(target)) {
                        if (trace) {
                            log.trace((Object)("Setting " + target + " as the new sticky target"));
                        }
                        txStickyTarget = target;
                    }
                    Object newViewId = rsp;
                    return newViewId;
                }
                catch (DispatcherConnectException dce) {
                    block24: {
                        ByteArrayOutputStream bis = new ByteArrayOutputStream();
                        PrintStream ps = new PrintStream(bis);
                        dce.printStackTrace(ps);
                        sb.append("DispatcherConnectException: " + new String(bis.toByteArray()) + "\n");
                        DispatcherConnectException dispatcherConnectException = dce;
                        break block24;
                        catch (CannotConnectException ex) {
                            bis = new ByteArrayOutputStream();
                            ps = new PrintStream(bis);
                            ex.printStackTrace(ps);
                            sb.append("CannotConnectException: " + new String(bis.toByteArray()) + "\n");
                            CannotConnectException cannotConnectException = ex;
                            break block24;
                        }
                        catch (GenericClusteringException gce) {
                            bis = new ByteArrayOutputStream();
                            ps = new PrintStream(bis);
                            gce.printStackTrace(ps);
                            sb.append("GenericClusteringException: " + new String(bis.toByteArray()) + "\n");
                            GenericClusteringException genericClusteringException = gce;
                            if (gce.getCompletionStatus() != 1) {
                                this.invocationHasReachedAServer(target);
                                throw new RuntimeException("Clustering exception thrown", (Throwable)((Object)gce));
                            }
                            if (family.get().getTargets().size() >= failoverCounter && !gce.isDefinitive()) {
                                definitivlyRemoveNodeOnFailure = false;
                            }
                            break block24;
                        }
                        catch (Throwable t) {
                            GenericClusteringException gce;
                            bis = new ByteArrayOutputStream();
                            ps = new PrintStream(bis);
                            t.printStackTrace(ps);
                            sb.append("Throwable: " + new String(bis.toByteArray()) + "\n");
                            if (!(t.getCause() instanceof GenericClusteringException)) throw t;
                            GenericClusteringException genericClusteringException = gce = (GenericClusteringException)((Object)t.getCause());
                            if (gce.getCompletionStatus() != 1) {
                                this.invocationHasReachedAServer(target);
                                throw new RuntimeException("Clustering exception thrown", (Throwable)((Object)gce));
                            }
                            if (family.get().getTargets().size() < failoverCounter || gce.isDefinitive()) break block24;
                            definitivlyRemoveNodeOnFailure = false;
                        }
                    }
                    family.get().removeDeadTarget(target);
                    sb.append("---------------------------------------------------");
                    sb.append("Remove dead target: " + target);
                    sb.append("---------------------------------------------------");
                    if (!definitivlyRemoveNodeOnFailure) {
                        family.get().resetView();
                    }
                    target = (InvokerLocator)lb.chooseTarget(family.get());
                    sb.append("---------------------------------------------------");
                    sb.append("New target: " + txStickyTarget);
                    sb.append("---------------------------------------------------");
                    if (target == null) {
                        void var10_18;
                        if (var10_18 == null) throw new RuntimeException("cluster invocation failed");
                        throw new RuntimeException("cluster invocation failed, last exception was: ", (Throwable)var10_18);
                    }
                    failoverAuthorized = !supportsTxStickiness || this.txContextAllowsFailover();
                    ++failoverCounter;
                }
            }
            if (!supportsTxStickiness) throw new RuntimeException("Unreachable?: Service unavailable.");
            if (failoverAuthorized) throw new RuntimeException("Unreachable?: Service unavailable.");
            throw new RuntimeException("Current transaction is stuck to " + txStickyTarget + " which is no longer available.  Halting invocation.");
        }
        finally {
            log.info((Object)sb.toString());
        }
    }

    private Object getTransactionPropagationContext() {
        TransactionPropagationContextFactory factory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
        return factory != null ? factory.getTransactionPropagationContext() : null;
    }

    private boolean txContextAllowsFailover() {
        Object tpc = this.getTransactionPropagationContext();
        if (tpc != null) {
            return !txStickyTargets.containsKey(tpc);
        }
        return true;
    }

    private boolean invocationHasReachedAServer(InvokerLocator target) {
        Object tpc = this.getTransactionPropagationContext();
        if (tpc != null) {
            txStickyTargets.put(tpc, target);
        }
        return tpc != null;
    }
}

