/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.logging.Logger;

public class FamilyWrapper
implements Externalizable {
    public static final String DISABLE_TX_STICKINESS = "jboss.ejb3.clustering.disableTxStickiness";
    private static final long serialVersionUID = 3880844152274576311L;
    private static final Logger logger = Logger.getLogger(FamilyWrapper.class);
    private FamilyClusterInfo info;
    private boolean txStickinessSupported;

    public FamilyWrapper() {
    }

    public FamilyWrapper(String proxyFamilyName, List targets) {
        this.info = ClusteringTargetsRepository.initTarget(proxyFamilyName, targets);
        this.txStickinessSupported = !Boolean.getBoolean(DISABLE_TX_STICKINESS);
    }

    public FamilyClusterInfo get() {
        return this.info;
    }

    public boolean isTxStickinessSupported() {
        return this.txStickinessSupported;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.info.getFamilyName());
        out.writeObject(new ArrayList(this.info.getTargets()));
        out.writeBoolean(this.txStickinessSupported);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String proxyFamilyName = (String)in.readObject();
        List targets = (List)in.readObject();
        FamilyClusterInfo currentInfo = ClusteringTargetsRepository.getFamilyClusterInfo(proxyFamilyName);
        if (currentInfo == null) {
            this.info = ClusteringTargetsRepository.initTarget(proxyFamilyName, targets);
        } else {
            if (!currentInfo.getTargets().equals(targets)) {
                logger.warn((Object)("Current view " + currentInfo.getTargets() + ", does not match serialized view " + targets));
            }
            this.info = currentInfo;
        }
        this.txStickinessSupported = in.available() > 0 ? in.readBoolean() : true;
    }
}

