/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.logging.Logger;

public class HATarget
implements DistributedReplicantManager.ReplicantListener {
    public static final int DISABLE_INVOCATIONS = 0;
    public static final int MAKE_INVOCATIONS_WAIT = 1;
    public static final int ENABLE_INVOCATIONS = 2;
    protected String replicantName;
    protected ArrayList replicants = new ArrayList();
    protected HAPartition partition = null;
    protected Logger log;
    protected int clusterViewId = 0;
    protected Serializable target;
    protected int allowInvocationsStatus = 0;
    protected CountDownLatch latch = null;

    public HATarget(HAPartition partition, String replicantName, Serializable target, int allowInvocations) throws Exception {
        this.replicantName = replicantName;
        this.target = target;
        this.init();
        this.setInvocationsAuthorization(allowInvocations);
        this.updateHAPartition(partition);
    }

    public void init() throws Exception {
        this.log = Logger.getLogger(this.getClass());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append('{');
        buffer.append("replicantName=" + this.replicantName);
        buffer.append("partition=" + this.partition.getPartitionName());
        buffer.append("clusterViewId=" + this.clusterViewId);
        buffer.append("allowInvocationsStatus=" + this.allowInvocationsStatus);
        buffer.append("replicants=" + this.replicants);
        buffer.append('}');
        return buffer.toString();
    }

    public long getCurrentViewId() {
        return this.clusterViewId;
    }

    public void destroy() {
        try {
            this.cleanExistenceInCurrentHAPartition();
            this.setInvocationsAuthorization(0);
        }
        catch (Exception e) {
            this.log.error((Object)"failed to destroy", (Throwable)e);
        }
    }

    public void disable() {
        try {
            if (this.partition != null) {
                this.log.debug((Object)"Disabled called on HATarget");
                this.partition.getDistributedReplicantManager().remove(this.replicantName);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"failed to disable", (Throwable)e);
        }
    }

    public ArrayList getReplicants() {
        return this.replicants;
    }

    public void updateHAPartition(HAPartition partition) throws Exception {
        this.cleanExistenceInCurrentHAPartition();
        this.partition = partition;
        DistributedReplicantManager drm = partition.getDistributedReplicantManager();
        drm.registerListener(this.replicantName, this);
        drm.add(this.replicantName, this.target);
    }

    public synchronized void setInvocationsAuthorization(int status) {
        if (this.allowInvocationsStatus == status) {
            this.log.debug((Object)"Invocation authorization called with no-op");
        } else if (status == 1) {
            this.log.debug((Object)"Invocation authorization called: MAKE_INVOCATIONS_WAIT");
            this.latch = new CountDownLatch(1);
            this.allowInvocationsStatus = status;
        } else {
            this.log.debug((Object)("Invocation authorization called: " + (status == 2 ? "ENABLE_INVOCATIONS" : "DISABLE_INVOCATIONS")));
            this.allowInvocationsStatus = status;
            this.releaseCurrentLatch();
        }
    }

    public boolean invocationsAllowed() throws InterruptedException {
        if (this.allowInvocationsStatus == 2) {
            return true;
        }
        if (this.allowInvocationsStatus == 0) {
            return false;
        }
        if (this.allowInvocationsStatus == 1) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Blocking invocation for service " + this.replicantName));
            }
            this.latch.await();
            return this.allowInvocationsStatus == 2;
        }
        return false;
    }

    protected void releaseCurrentLatch() {
        if (this.latch != null) {
            this.latch.countDown();
            this.latch = null;
        }
    }

    public HAPartition getAssociatedPartition() {
        return this.partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicantsChanged(String key, List newReplicants, int newReplicantsViewId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("replicantsChanged '" + this.replicantName + "' to " + (newReplicants == null ? "0 (null)" : Integer.toString(newReplicants.size())) + " (intra-view id: " + newReplicantsViewId + ")"));
        }
        ArrayList arrayList = this.replicants;
        synchronized (arrayList) {
            this.replicants.clear();
            if (newReplicants != null) {
                this.replicants.addAll(newReplicants);
            }
            this.clusterViewId = newReplicantsViewId;
        }
    }

    protected void cleanExistenceInCurrentHAPartition() {
        if (this.partition != null) {
            try {
                DistributedReplicantManager drm = this.partition.getDistributedReplicantManager();
                drm.unregisterListener(this.replicantName, this);
                drm.remove(this.replicantName);
            }
            catch (Exception e) {
                this.log.error((Object)"failed to clean existence in current ha partition", (Throwable)e);
            }
        }
    }
}

