/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.lock;

import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.lock.LocalLockHandler;
import org.jboss.ha.framework.server.lock.NonGloballyExclusiveClusterLockSupport;
import org.jboss.ha.framework.server.lock.TimeoutException;

public class LocalAndClusterLockManager {
    private ClusterNode localNode;
    private ConcurrentMap<Serializable, LocalLock> localLocks = new ConcurrentHashMap<Serializable, LocalLock>();
    private final NonGloballyExclusiveClusterLockSupport clusterSupport;

    public LocalAndClusterLockManager(String serviceHAName, HAPartition partition) {
        ClusterHandler handler = new ClusterHandler();
        this.clusterSupport = new NonGloballyExclusiveClusterLockSupport(serviceHAName, partition, handler);
    }

    public void lockLocally(Serializable lockName, long timeout) throws TimeoutException, InterruptedException {
        if (this.localNode == null) {
            throw new IllegalStateException("Null localNode");
        }
        this.doLock(lockName, this.localNode, timeout);
    }

    public void unlockLocally(Serializable lockName) {
        if (this.localNode == null) {
            throw new IllegalStateException("Null localNode");
        }
        this.doUnlock(lockName, this.localNode);
    }

    public void lockGlobally(Serializable lockName, long timeout) throws TimeoutException, InterruptedException {
        this.clusterSupport.lock(lockName, timeout);
    }

    public void unlockGlobally(Serializable lockName) {
        this.clusterSupport.unlock(lockName);
    }

    public void start() throws Exception {
        this.clusterSupport.start();
    }

    public void stop() throws Exception {
        this.clusterSupport.stop();
    }

    private LocalLock getLocalLock(Serializable categoryName, boolean create) {
        LocalLock existing;
        LocalLock category = (LocalLock)this.localLocks.get(categoryName);
        if (category == null && create && (existing = this.localLocks.putIfAbsent(categoryName, category = new LocalLock())) != null) {
            category = existing;
        }
        return category;
    }

    private void doLock(Serializable lockName, ClusterNode caller, long timeout) throws TimeoutException, InterruptedException {
        LocalLock lock = this.getLocalLock(lockName, true);
        lock.lock(caller, timeout);
    }

    private void doUnlock(Serializable lockName, ClusterNode caller) {
        LocalLock lock = this.getLocalLock(lockName, false);
        if (lock != null) {
            lock.unlock(caller);
        }
    }

    private class ClusterHandler
    implements LocalLockHandler {
        private ClusterHandler() {
        }

        @Override
        public ClusterNode getLocalNode(ClusterNode localNode) {
            return LocalAndClusterLockManager.this.localNode;
        }

        @Override
        public void setLocalNode(ClusterNode localNode) {
            LocalAndClusterLockManager.this.localNode = localNode;
        }

        @Override
        public void lockFromCluster(Serializable lockName, ClusterNode caller, long timeout) throws TimeoutException, InterruptedException {
            LocalAndClusterLockManager.this.doLock(lockName, caller, timeout);
        }

        @Override
        public ClusterNode getLockHolder(Serializable lockName) {
            LocalLock lock = LocalAndClusterLockManager.this.getLocalLock(lockName, false);
            return lock == null ? null : lock.holder;
        }

        @Override
        public void unlockFromCluster(Serializable lockName, ClusterNode caller) {
            LocalAndClusterLockManager.this.doUnlock(lockName, caller);
        }
    }

    private class LocalLock {
        private volatile ClusterNode holder;
        private final AtomicBoolean locked = new AtomicBoolean(false);
        private final Queue<Thread> waiters = new ConcurrentLinkedQueue<Thread>();

        private LocalLock() {
        }

        private void lock(ClusterNode caller, long timeout) throws TimeoutException {
            block7: {
                long deadline = System.currentTimeMillis() + timeout;
                boolean wasInterrupted = false;
                Thread current = Thread.currentThread();
                this.waiters.add(current);
                try {
                    while (this.waiters.peek() != current || !this.locked.compareAndSet(false, true)) {
                        LockSupport.parkUntil(deadline);
                        if (Thread.interrupted()) {
                            wasInterrupted = true;
                        }
                        if (System.currentTimeMillis() < deadline) continue;
                        if (this.waiters.peek() == current && this.locked.compareAndSet(false, true)) break;
                        throw new TimeoutException(this.holder);
                    }
                    if (this.locked.get()) {
                        this.holder = caller;
                        break block7;
                    }
                    throw new TimeoutException(this.holder);
                }
                finally {
                    this.waiters.remove();
                    if (wasInterrupted) {
                        current.interrupt();
                    }
                }
            }
        }

        private void unlock(ClusterNode caller) {
            if (caller.equals(this.holder)) {
                this.locked.set(false);
                this.holder = null;
                LockSupport.unpark(this.waiters.peek());
            }
        }
    }
}

