/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheManager;
import org.jboss.cache.CacheStatus;
import org.jboss.ha.framework.server.spi.HAPartitionCacheHandler;
import org.jgroups.ChannelFactory;

public class HAPartitionCacheHandlerImpl
implements HAPartitionCacheHandler {
    private CacheManager cacheManager;
    private String cacheConfigName;
    private Cache<Object, Object> cache;
    private AtomicInteger acquireCount = new AtomicInteger();

    public synchronized void acquireCache() throws Exception {
        if (this.cache == null) {
            this.validateState();
            this.cache = this.cacheManager.getCache(this.cacheConfigName, true);
        }
        this.acquireCount.incrementAndGet();
    }

    public synchronized void startCache() throws Exception {
        if (this.cache == null) {
            throw new IllegalStateException("Must acquire cache before starting it");
        }
        if (this.cache.getCacheStatus() != CacheStatus.STARTED) {
            this.cache.start();
        }
    }

    public synchronized void releaseCache() throws Exception {
        if (this.cache != null) {
            this.validateState();
            if (this.acquireCount.decrementAndGet() == 0) {
                this.cacheManager.releaseCache(this.cacheConfigName);
                this.cache = null;
            }
        }
    }

    public synchronized String getCacheConfigName() {
        return this.cacheConfigName;
    }

    public synchronized String getChannelStackName() {
        if (this.cache == null) {
            throw new IllegalStateException("Must acquire cache before getting channel stack name");
        }
        return this.cache.getConfiguration().getMultiplexerStack();
    }

    public synchronized ChannelFactory getCacheChannelFactory() {
        if (this.cache == null) {
            throw new IllegalStateException("Must acquire cache before getting cache channel factory");
        }
        return this.cache.getConfiguration().getRuntimeConfig().getMuxChannelFactory();
    }

    public synchronized void setCacheConfigName(String cacheConfigName) {
        this.cacheConfigName = cacheConfigName;
    }

    public synchronized CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public synchronized void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public synchronized Cache<Object, Object> getCache() {
        return this.cache;
    }

    private void validateState() {
        if (this.cacheManager == null) {
            throw new IllegalStateException("Must set cacheManager");
        }
        if (this.cacheConfigName == null) {
            throw new IllegalStateException("Must set cacheConfigName");
        }
    }
}

