/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.cachemanager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationRegistry;
import org.jboss.cache.config.RuntimeConfig;
import org.jboss.cache.config.XmlParsingConfigurationRegistry;
import org.jboss.cache.jmx.CacheJmxWrapper;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.event.CacheStartedEvent;
import org.jboss.cache.notifications.event.CacheStoppedEvent;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheFactory;
import org.jboss.cache.pojo.jmx.PojoCacheJmxWrapper;
import org.jboss.ha.cachemanager.CacheManagerMBean;
import org.jboss.ha.cachemanager.CacheManagerManagedCache;
import org.jboss.ha.cachemanager.MuxHandlerChannel;
import org.jboss.ha.cachemanager.PojoCacheManagerManagedPojoCache;
import org.jboss.ha.framework.server.CacheManagerLocator;
import org.jboss.ha.framework.server.PojoCacheManager;
import org.jboss.ha.framework.server.PojoCacheManagerLocator;
import org.jboss.logging.Logger;
import org.jboss.util.naming.NonSerializableFactory;
import org.jgroups.Channel;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannel;

public class CacheManager
implements org.jboss.cache.CacheManager,
PojoCacheManager,
MBeanRegistration,
CacheManagerMBean {
    private static final Logger log = Logger.getLogger(CacheManager.class);
    public static final String DEFAULT_CORE_CACHE_JMX_ATTRIBUTES = "service=Cache,config=";
    public static final String DEFAULT_POJO_CACHE_JMX_ATTRIBUTES = "service=Cache,cacheType=PojoCache,config=";
    private static final ThreadLocal<Boolean> starting = new ThreadLocal();
    private MBeanServer mbeanServer;
    private String jmxDomain;
    private String coreCacheJmxAttributes = "service=Cache,config=";
    private String pojoCacheJmxAttributes = "service=Cache,cacheType=PojoCache,config=";
    private ConfigurationRegistry configRegistry;
    private boolean configRegistryInjected;
    private ChannelFactory channelFactory;
    private final Map<String, Cache<Object, Object>> plainCaches = new HashMap<String, Cache<Object, Object>>();
    private final Map<String, Integer> plainCacheCheckouts = new HashMap<String, Integer>();
    private Map<String, PojoCache> pojoCaches = new HashMap<String, PojoCache>();
    private Map<String, Integer> pojoCacheCheckouts = new HashMap<String, Integer>();
    private Map<String, String> configAliases = new HashMap<String, String>();
    private boolean registerCachesInJmx = true;
    private Map<String, Boolean> startupCaches = new HashMap<String, Boolean>();
    private String jndiName;
    private boolean started;

    public CacheManager() {
    }

    public CacheManager(ConfigurationRegistry configRegistry, ChannelFactory factory) {
        this.configRegistry = configRegistry;
        this.configRegistryInjected = true;
        this.channelFactory = factory;
    }

    public CacheManager(String configFileName, ChannelFactory factory) {
        this.configRegistry = new XmlParsingConfigurationRegistry(configFileName);
        this.channelFactory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getPojoCacheNames() {
        Map<String, PojoCache> map = this.pojoCaches;
        synchronized (map) {
            return new HashSet<String>(this.pojoCaches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PojoCache getPojoCache(String configName, boolean create) throws Exception {
        if (create) {
            this.checkStarted();
        }
        configName = this.resolveAlias(configName);
        PojoCache cache = null;
        Map<String, PojoCache> map = this.pojoCaches;
        synchronized (map) {
            if (this.getCacheNames().contains(configName)) {
                throw new IllegalStateException("Cannot create PojoCache: plain cache already created for config " + configName);
            }
            cache = this.pojoCaches.get(configName);
            if (cache == null && create) {
                Configuration config = this.getConfigurationRegistry().getConfiguration(configName);
                if (this.getChannelFactory() != null && config.getMultiplexerStack() != null) {
                    config.getRuntimeConfig().setMuxChannelFactory(this.getChannelFactory());
                }
                cache = this.createPojoCache(config);
                this.registerPojoCache(cache, configName);
            } else if (cache != null) {
                this.incrementPojoCacheCheckout(configName);
            }
        }
        return cache == null ? null : new PojoCacheManagerManagedPojoCache(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPojoCache(PojoCache cache, String configName) {
        this.checkStarted();
        Map<String, PojoCache> map = this.pojoCaches;
        synchronized (map) {
            if (this.pojoCaches.containsKey(configName) || this.getCacheNames().contains(configName)) {
                throw new IllegalStateException(configName + " already registered");
            }
            this.pojoCaches.put(configName, cache);
            this.incrementPojoCacheCheckout(configName);
            if (this.registerCachesInJmx && this.mbeanServer != null) {
                String oName = this.getObjectName(this.getPojoCacheJmxAttributes(), configName);
                PojoCacheJmxWrapper wrapper = new PojoCacheJmxWrapper(cache);
                try {
                    this.mbeanServer.registerMBean(wrapper, new ObjectName(oName));
                }
                catch (JMException e) {
                    throw new RuntimeException("Cannot register cache under name " + oName, e);
                }
                cache.getCache().addCacheListener((Object)new StartStopListener(wrapper));
            }
        }
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getConfigurationNames() {
        Map<String, PojoCache> map = this.pojoCaches;
        synchronized (map) {
            Set<String> configNames = this.getPlainCacheConfigurationNames();
            configNames.addAll(this.getPojoCacheNames());
            configNames.addAll(this.configAliases.keySet());
            return configNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getCacheNames() {
        Map<String, Cache<Object, Object>> map = this.plainCaches;
        synchronized (map) {
            return new HashSet<String>(this.plainCaches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache<Object, Object> getCache(String configName, boolean create) throws Exception {
        if (create) {
            this.checkStarted();
        }
        configName = this.resolveAlias(configName);
        Map<String, PojoCache> map = this.pojoCaches;
        synchronized (map) {
            if (create && this.pojoCaches.containsKey(configName)) {
                log.debug((Object)("Plain cache requested for config " + configName + " but a PojoCache is already registered; returning " + " the PojoCache's underlying plain cache"));
                PojoCache pc = this.getPojoCache(configName, false);
                if (pc != null) {
                    return this.wrapCache((Cache<Object, Object>)pc.getCache());
                }
            }
            return this.wrapCache(this.getPlainCache(configName, create));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCache(Cache<Object, Object> cache, String configName) {
        this.checkStarted();
        Map<String, PojoCache> map = this.pojoCaches;
        synchronized (map) {
            if (this.pojoCaches.containsKey(configName)) {
                throw new IllegalStateException(configName + " already registered");
            }
            this.registerPlainCache(cache, configName);
            if (this.registerCachesInJmx && this.mbeanServer != null) {
                String oName = this.getObjectName(this.getCoreCacheJmxAttributes(), configName);
                CacheJmxWrapper wrapper = new CacheJmxWrapper(cache);
                try {
                    this.mbeanServer.registerMBean(wrapper, new ObjectName(oName));
                }
                catch (JMException e) {
                    throw new RuntimeException("Cannot register cache under name " + oName, e);
                }
                cache.addCacheListener((Object)new StartStopListener(wrapper));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCache(String configName) {
        configName = this.resolveAlias(configName);
        Map<String, PojoCache> map = this.pojoCaches;
        synchronized (map) {
            if (this.pojoCaches.containsKey(configName)) {
                if (this.decrementPojoCacheCheckout(configName) == 0) {
                    PojoCache cache = this.pojoCaches.remove(configName);
                    this.destroyPojoCache(configName, cache);
                }
            } else {
                Map<String, Cache<Object, Object>> map2 = this.plainCaches;
                synchronized (map2) {
                    if (!this.plainCaches.containsKey(configName)) {
                        throw new IllegalStateException(configName + " not registered");
                    }
                    if (this.decrementPlainCacheCheckout(configName) == 0) {
                        Cache<Object, Object> cache = this.plainCaches.remove(configName);
                        this.destroyPlainCache(cache, configName);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (!this.started) {
            if (this.configRegistry == null) {
                throw new IllegalStateException("Must configure a ConfigurationRegistry before calling start()");
            }
            if (this.channelFactory == null) {
                throw new IllegalStateException("Must provide a ChannelFactory before calling start()");
            }
            try {
                PojoCacheManagerLocator pclocator;
                starting.set(Boolean.TRUE);
                if (!this.configRegistryInjected) {
                    ((XmlParsingConfigurationRegistry)this.configRegistry).start();
                }
                this.startEagerStartCaches();
                CacheManagerLocator locator = CacheManagerLocator.getCacheManagerLocator();
                if (locator.getDirectlyRegisteredManager() == null) {
                    locator.registerCacheManager((org.jboss.cache.CacheManager)this);
                }
                if ((pclocator = PojoCacheManagerLocator.getCacheManagerLocator()).getDirectlyRegisteredManager() == null) {
                    pclocator.registerCacheManager((PojoCacheManager)this);
                }
                if (this.jndiName != null) {
                    InitialContext ctx = new InitialContext();
                    this.bind(this.jndiName, this, CacheManager.class, ctx);
                    log.debug((Object)("Bound in JNDI under " + this.jndiName));
                }
            }
            finally {
                starting.remove();
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.started) {
            PojoCacheManagerLocator pclocator;
            CacheManagerLocator locator;
            this.releaseEagerStartCaches();
            if (!this.configRegistryInjected) {
                ((XmlParsingConfigurationRegistry)this.configRegistry).stop();
            }
            if (this.jndiName != null) {
                InitialContext ctx = null;
                try {
                    ctx = new InitialContext();
                    ctx.unbind(this.jndiName);
                }
                catch (Exception e) {
                    log.error((Object)"partition unbind operation failed", (Throwable)e);
                }
                finally {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (NamingException e) {
                            log.error((Object)"Caught exception closing naming context", (Throwable)e);
                        }
                    }
                }
                try {
                    NonSerializableFactory.unbind((String)this.jndiName);
                }
                catch (NameNotFoundException e) {
                    log.error((Object)"Caught exception unbinding from NonSerializableFactory", (Throwable)e);
                }
            }
            if ((locator = CacheManagerLocator.getCacheManagerLocator()).getDirectlyRegisteredManager() == this) {
                locator.deregisterCacheManager();
            }
            if ((pclocator = PojoCacheManagerLocator.getCacheManagerLocator()).getDirectlyRegisteredManager() == this) {
                pclocator.deregisterCacheManager();
            }
            this.started = false;
        }
    }

    public ConfigurationRegistry getConfigurationRegistry() {
        return this.configRegistry;
    }

    public void setConfigurationRegistry(ConfigurationRegistry configRegistry) {
        this.configRegistry = configRegistry;
        this.configRegistryInjected = true;
    }

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    @Override
    public String getJmxDomain() {
        return this.jmxDomain;
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    @Override
    public String getCoreCacheJmxAttributes() {
        return this.coreCacheJmxAttributes;
    }

    public void setCoreCacheJmxAttributes(String coreCacheJmxAttributes) {
        this.coreCacheJmxAttributes = coreCacheJmxAttributes;
    }

    @Override
    public String getPojoCacheJmxAttributes() {
        return this.pojoCacheJmxAttributes;
    }

    public void setPojoCacheJmxAttributes(String pojoCacheJmxAttributes) {
        this.pojoCacheJmxAttributes = pojoCacheJmxAttributes;
    }

    @Override
    public boolean getRegisterCachesInJmx() {
        return this.registerCachesInJmx;
    }

    public void setRegisterCachesInJmx(boolean register) {
        this.registerCachesInJmx = register;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getConfigAliases() {
        Map<String, String> map = this.configAliases;
        synchronized (map) {
            return new HashMap<String, String>(this.configAliases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigAliases(Map<String, String> aliases) {
        Map<String, String> map = this.configAliases;
        synchronized (map) {
            this.configAliases.clear();
            if (aliases != null) {
                this.configAliases.putAll(aliases);
            }
        }
    }

    public void setEagerStartCaches(Set<String> configNames) {
        if (configNames != null) {
            for (String name : configNames) {
                this.startupCaches.put(name, Boolean.FALSE);
            }
        }
    }

    public void setEagerStartPojoCaches(Set<String> configNames) {
        if (configNames != null) {
            for (String name : configNames) {
                this.startupCaches.put(name, Boolean.TRUE);
            }
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        if (this.jmxDomain == null) {
            this.jmxDomain = name.getDomain();
        }
        return name;
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    protected PojoCache createPojoCache(Configuration config) throws Exception {
        PojoCache pc = PojoCacheFactory.createCache((Configuration)config, (boolean)false);
        this.configureMuxUpHandlerChannel(pc.getCache());
        return pc;
    }

    protected Cache<Object, Object> createCache(Configuration config) throws Exception {
        Cache cache = new DefaultCacheFactory().createCache(config, false);
        this.configureMuxUpHandlerChannel(cache);
        return cache;
    }

    private void checkStarted() {
        if (!this.started && !Boolean.TRUE.equals(starting.get())) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incrementCheckout(String configName) {
        Map<String, Integer> map = this.plainCacheCheckouts;
        synchronized (map) {
            Integer count = this.plainCacheCheckouts.get(configName);
            if (count == null) {
                count = 0;
            }
            Integer newVal = count + 1;
            this.plainCacheCheckouts.put(configName, newVal);
            return newVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decrementPlainCacheCheckout(String configName) {
        Map<String, Integer> map = this.plainCacheCheckouts;
        synchronized (map) {
            Integer count = this.plainCacheCheckouts.get(configName);
            if (count == null || count < 1) {
                throw new IllegalStateException("invalid count of " + count + " for " + configName);
            }
            Integer newVal = count - 1;
            this.plainCacheCheckouts.put(configName, newVal);
            return newVal;
        }
    }

    private void destroyPlainCache(Cache<Object, Object> cache, String configName) {
        if (cache.getCacheStatus() == CacheStatus.STARTED) {
            cache.stop();
        }
        if (cache.getCacheStatus() != CacheStatus.DESTROYED && cache.getCacheStatus() != CacheStatus.INSTANTIATED) {
            cache.destroy();
        }
        if (this.registerCachesInJmx && this.mbeanServer != null && !this.getCacheNames().contains(configName)) {
            String oNameStr = this.getObjectName(this.getCoreCacheJmxAttributes(), configName);
            try {
                ObjectName oName = new ObjectName(oNameStr);
                if (this.mbeanServer.isRegistered(oName)) {
                    this.mbeanServer.unregisterMBean(oName);
                }
            }
            catch (JMException e) {
                log.error((Object)("Problem unregistering CacheJmxWrapper " + oNameStr), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPlainCache(Cache<Object, Object> cache, String configName) {
        Map<String, Cache<Object, Object>> map = this.plainCaches;
        synchronized (map) {
            if (this.plainCaches.containsKey(configName)) {
                throw new IllegalStateException(configName + " already registered");
            }
            this.plainCaches.put(configName, cache);
            this.incrementCheckout(configName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<Object, Object> getPlainCache(String configName, boolean create) throws Exception {
        Cache<Object, Object> cache;
        Map<String, Cache<Object, Object>> map = this.plainCaches;
        synchronized (map) {
            cache = this.plainCaches.get(configName);
            if (cache == null && create) {
                Configuration config = this.configRegistry.getConfiguration(configName);
                if (this.channelFactory != null && config.getMultiplexerStack() != null) {
                    config.getRuntimeConfig().setMuxChannelFactory(this.channelFactory);
                }
                cache = this.createCache(config);
                this.registerCache(cache, configName);
            } else if (cache != null) {
                this.incrementCheckout(configName);
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getPlainCacheConfigurationNames() {
        Map<String, Cache<Object, Object>> map = this.plainCaches;
        synchronized (map) {
            Set<String> configNames = this.configRegistry == null ? new HashSet() : this.configRegistry.getConfigurationNames();
            configNames.addAll(this.getCacheNames());
            return configNames;
        }
    }

    private Cache<Object, Object> wrapCache(Cache<Object, Object> toWrap) {
        return toWrap == null ? null : new CacheManagerManagedCache<Object, Object>(toWrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incrementPojoCacheCheckout(String configName) {
        Map<String, Integer> map = this.pojoCacheCheckouts;
        synchronized (map) {
            Integer count = this.pojoCacheCheckouts.get(configName);
            if (count == null) {
                count = 0;
            }
            Integer newVal = count + 1;
            this.pojoCacheCheckouts.put(configName, newVal);
            return newVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decrementPojoCacheCheckout(String configName) {
        Map<String, Integer> map = this.pojoCacheCheckouts;
        synchronized (map) {
            Integer count = this.pojoCacheCheckouts.get(configName);
            if (count == null || count < 1) {
                throw new IllegalStateException("invalid count of " + count + " for " + configName);
            }
            Integer newVal = count - 1;
            this.pojoCacheCheckouts.put(configName, newVal);
            return newVal;
        }
    }

    private void destroyPojoCache(String configName, PojoCache pojoCache) {
        Cache cache = pojoCache.getCache();
        if (cache.getCacheStatus() == CacheStatus.STARTED) {
            pojoCache.stop();
        }
        if (cache.getCacheStatus() != CacheStatus.DESTROYED && cache.getCacheStatus() != CacheStatus.INSTANTIATED) {
            pojoCache.destroy();
        }
        if (this.registerCachesInJmx && this.mbeanServer != null) {
            String oNameStr = this.getObjectName(this.getPojoCacheJmxAttributes(), configName);
            try {
                ObjectName oName = new ObjectName(oNameStr);
                if (this.mbeanServer.isRegistered(oName)) {
                    this.mbeanServer.unregisterMBean(oName);
                }
            }
            catch (JMException e) {
                log.error((Object)("Problem unregistering PojoCacheJmxWrapper " + oNameStr), (Throwable)e);
            }
        }
    }

    private String getObjectName(String attributesBase, String configName) {
        String base = this.getJmxDomain() == null ? "" : this.getJmxDomain();
        return base + ":" + attributesBase + configName;
    }

    private void configureMuxUpHandlerChannel(Cache<?, ?> cache) throws Exception {
        RuntimeConfig rc = cache.getConfiguration().getRuntimeConfig();
        Channel channel = rc.getChannel();
        if (channel == null) {
            String stack;
            ChannelFactory cf = rc.getMuxChannelFactory();
            if (cf == null) {
                log.debug((Object)("Cache " + cache.getConfiguration().getClusterName() + " does not have a ChannelFactory injected so MuxUpHandler cannot be integrated"));
            }
            if ((stack = cache.getConfiguration().getMuxStackName()) == null) {
                log.debug((Object)("Cache " + cache.getConfiguration().getClusterName() + " does not have a MuxStackName configured so MuxUpHandler cannot be integrated"));
            }
            if (cf != null && stack != null) {
                channel = cf.createMultiplexerChannel(stack, cache.getConfiguration().getClusterName());
                rc.setChannel((Channel)new MuxHandlerChannel((JChannel)channel));
            }
        } else if (channel.getUpHandler() == null) {
            rc.setChannel((Channel)new MuxHandlerChannel((JChannel)channel));
        }
    }

    private void bind(String jndiName, Object who, Class<?> classType, Context ctx) throws Exception {
        NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                log.debug((Object)("creating Subcontext " + ctxName));
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, NonSerializableFactory.class.getName(), null);
        ctx.rebind(n.get(0), (Object)ref);
    }

    private String resolveAlias(String configName) {
        String alias = this.configAliases.get(configName);
        return alias == null ? configName : alias;
    }

    private void startEagerStartCaches() throws Exception {
        for (Map.Entry<String, Boolean> entry : this.startupCaches.entrySet()) {
            Cache cache = null;
            if (entry.getValue().booleanValue()) {
                PojoCache pc = this.getPojoCache(entry.getKey(), true);
                cache = pc.getCache();
            } else {
                cache = this.getCache(entry.getKey(), true);
            }
            if (cache.getCacheStatus() == CacheStatus.STARTED) continue;
            if (cache.getCacheStatus() != CacheStatus.CREATED) {
                cache.create();
            }
            cache.start();
        }
    }

    private void releaseEagerStartCaches() {
        for (String name : this.startupCaches.keySet()) {
            this.releaseCache(name);
        }
    }

    @CacheListener
    public static class StartStopListener {
        private final CacheJmxWrapper<Object, Object> plainWrapper;
        private final PojoCacheJmxWrapper pojoWrapper;

        private StartStopListener(CacheJmxWrapper<Object, Object> wrapper) {
            assert (wrapper != null) : "wrapper is null";
            this.plainWrapper = wrapper;
            this.pojoWrapper = null;
        }

        private StartStopListener(PojoCacheJmxWrapper wrapper) {
            assert (wrapper != null) : "wrapper is null";
            this.pojoWrapper = wrapper;
            this.plainWrapper = null;
        }

        @CacheStarted
        public void cacheStarted(CacheStartedEvent event) {
            if (this.plainWrapper != null) {
                this.plainWrapper.start();
            } else {
                this.pojoWrapper.start();
            }
        }

        @CacheStopped
        public void cacheStopped(CacheStoppedEvent event) {
            if (this.plainWrapper != null) {
                this.plainWrapper.stop();
            } else {
                this.pojoWrapper.stop();
            }
        }
    }
}

