/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

/**
 * Base class for JBC cache listener impls.
 * 
 * @author Brian Stansberry
 */
public class CacheListenerBase
{

   private static final int WEBAPP_FQN_INDEX = 1;
   protected static final int SESSION_ID_FQN_INDEX = 2;
   private static final int SESSION_FQN_SIZE = SESSION_ID_FQN_INDEX + 1;
   
   protected LocalDistributableSessionManager manager_;
   private String contextHostPath_;

   CacheListenerBase(LocalDistributableSessionManager manager, String contextHostPath)
   {      
      this.manager_ = manager;
      this.contextHostPath_ = contextHostPath;
   }
   
   protected boolean isFqnForOurWebapp(Fqn<String> fqn, int jsessionIndex)
   {
      try
      {
         return (jsessionIndex > -1 && contextHostPath_.equals(fqn.get(jsessionIndex + WEBAPP_FQN_INDEX)));
      }
      catch (IndexOutOfBoundsException e)
      {
         // can't be ours; too small; just fall through
      }
   
      return false;
   }

   @Deprecated
   protected boolean isFqnForOurWebapp(Fqn<String> fqn, boolean isBuddy)
   {
      int index = Util.getJSessionIndex(fqn, isBuddy);
      return isFqnForOurWebapp(fqn, index);
   }

   public static boolean isFqnSessionRootSized(Fqn<String> fqn, int jsessionIndex)
   {
      return fqn.size() == jsessionIndex + SESSION_FQN_SIZE;
   }

   @Deprecated
   public static boolean isFqnSessionRootSized(Fqn<String> fqn, boolean isBuddy)
   {
      int index = Util.getJSessionIndex(fqn, isBuddy);      
      return (isBuddy ? index > 0 && isFqnSessionRootSized(fqn, index) : isFqnSessionRootSized(fqn, index));
   }

   public static String getIdFromFqn(Fqn<String> fqn, int jsessionIndex)
   {
      return (String)fqn.get(jsessionIndex + SESSION_ID_FQN_INDEX);
   }
   
   @Deprecated
   public static String getIdFromFqn(Fqn<String> fqn, boolean isBuddy)
   {
      int index = Util.getJSessionIndex(fqn, isBuddy);
      return getIdFromFqn(fqn, index);
   }

   public static boolean isBuddyFqn(Fqn<String> fqn)
   {
      try
      {
         return BuddyManager.BUDDY_BACKUP_SUBTREE.equals(fqn.get(0));
      }
      catch (IndexOutOfBoundsException e)
      {
         // Can only happen if fqn is ROOT, and we shouldn't get
         // notifications for ROOT.
         // If it does, just means it's not a buddy
         return false;
      }      
   }
}