package org.jboss.creaper.commands.web;

import org.jboss.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.jboss.creaper.commands.foundation.offline.xml.Subtree;
import org.jboss.creaper.core.CommandFailedException;
import org.jboss.creaper.core.offline.OfflineCommand;
import org.jboss.creaper.core.offline.OfflineCommandContext;

import java.io.IOException;

/**
 * Command which enables natives in the Web subsystem.
 *
 * <p>{@code OnlineCommand} is not implemented as changing from natives to Java and back doesn't work
 * with the Web subsystem (restart is required).
 * See <a href="https://bugzilla.redhat.com/show_bug.cgi?id=1115443">Red Hat Bugzilla 1115443</a> for details.</p>.
 */
public final class EnableWebNatives implements OfflineCommand {
    @Override
    public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
        GroovyXmlTransform enableNatives = GroovyXmlTransform
                .of(EnableWebNatives.class)
                .subtree("web", Subtree.subsystem("web"))
                .build();
        ctx.client.apply(enableNatives);
    }
}
