/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.creaper.commands.datasources;

import java.io.IOException;
import org.jboss.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.jboss.creaper.commands.foundation.offline.xml.Subtree;
import org.jboss.creaper.core.CommandFailedException;
import org.jboss.creaper.core.offline.OfflineCommand;
import org.jboss.creaper.core.offline.OfflineCommandContext;
import org.jboss.creaper.core.online.OnlineCommand;
import org.jboss.creaper.core.online.OnlineCommandContext;
import org.jboss.creaper.core.online.operations.Address;
import org.jboss.creaper.core.online.operations.Operations;

public final class RemoveXADataSource
implements OnlineCommand,
OfflineCommand {
    private final String name;

    public RemoveXADataSource(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name of the xa-data-source must be specified as non null value");
        }
        this.name = name;
    }

    public void apply(OnlineCommandContext ctx) throws IOException {
        Operations ops = new Operations(ctx.client);
        ops.remove(Address.subsystem((String)"datasources").and("xa-data-source", this.name));
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException {
        GroovyXmlTransform transform = GroovyXmlTransform.of(RemoveXADataSource.class).subtree("datasources", Subtree.subsystem("datasources")).parameter("name", this.name).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public String toString() {
        return "RemoveXADataSource " + this.name;
    }
}

