/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.creaper.commands.domain;

import java.io.IOException;
import org.jboss.creaper.core.CommandFailedException;
import org.jboss.creaper.core.online.OnlineCommand;
import org.jboss.creaper.core.online.OnlineCommandContext;
import org.jboss.creaper.core.online.operations.Address;
import org.jboss.creaper.core.online.operations.Operations;
import org.jboss.creaper.core.online.operations.Values;

public class AddServerConfig
implements OnlineCommand {
    private final String serverName;
    private final String host;
    private final String socketBindingGroup;
    private final Integer socketBindingPortOffset;
    private final Boolean autoStart;
    private final String serverGroup;

    private AddServerConfig(Builder builder) {
        this.serverName = builder.serverName;
        this.host = builder.host;
        this.serverGroup = builder.serverGroup;
        this.socketBindingGroup = builder.socketBindingGroup;
        this.socketBindingPortOffset = builder.socketBindingPortOffset;
        this.autoStart = builder.autoStart;
    }

    public void apply(OnlineCommandContext ctx) throws CommandFailedException, IOException {
        if (!ctx.client.options().isDomain) {
            throw new CommandFailedException("This command only makes sense in domain");
        }
        Operations ops = new Operations(ctx.client);
        ops.add(this.getAddress(), Values.empty().andOptional("group", this.serverGroup).andOptional("socket-binding-group", this.socketBindingGroup).andOptional("socket-binding-port-offset", this.socketBindingPortOffset).andOptional("auto-start", this.autoStart));
    }

    public Address getAddress() {
        return Address.host((String)this.host).and("server-config", this.serverName);
    }

    public static final class Builder {
        private String serverName;
        private String host;
        private String serverGroup;
        private String socketBindingGroup;
        private Integer socketBindingPortOffset;
        private Boolean autoStart;

        public Builder(String serverName, String host, String serverGroup) {
            if (serverName == null) {
                throw new IllegalArgumentException("Name of the server must be specified as non null value");
            }
            if (host == null) {
                throw new IllegalArgumentException("host must be specified as non null value");
            }
            if (serverGroup == null) {
                throw new IllegalArgumentException("serverGroup must be specified as non null value");
            }
            this.serverName = serverName;
            this.host = host;
            this.serverGroup = serverGroup;
        }

        public Builder socketBindingGroup(String socketBindingGroup) {
            this.socketBindingGroup = socketBindingGroup;
            return this;
        }

        public Builder socketBindingPortOffset(int socketBindingPortOffset) {
            this.socketBindingPortOffset = socketBindingPortOffset;
            return this;
        }

        public Builder autoStart(boolean autoStart) {
            this.autoStart = autoStart;
            return this;
        }

        public AddServerConfig build() {
            return new AddServerConfig(this);
        }
    }
}

