/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.creaper.commands.domain;

import java.io.IOException;
import org.jboss.creaper.core.CommandFailedException;
import org.jboss.creaper.core.online.OnlineCommand;
import org.jboss.creaper.core.online.OnlineCommandContext;
import org.jboss.creaper.core.online.operations.Address;
import org.jboss.creaper.core.online.operations.Operations;
import org.jboss.creaper.core.online.operations.Values;

public class AddServerGroup
implements OnlineCommand {
    private final String groupName;
    private final String profile;
    private final String socketBindingGroup;
    private final Integer socketBindingPortOffset;

    private AddServerGroup(Builder builder) {
        this.groupName = builder.groupName;
        this.profile = builder.profile;
        this.socketBindingGroup = builder.socketBindingGroup;
        this.socketBindingPortOffset = builder.socketBindingPortOffset;
    }

    public void apply(OnlineCommandContext ctx) throws CommandFailedException, IOException {
        if (!ctx.client.options().isDomain) {
            throw new CommandFailedException("This command only makes sense in domain");
        }
        Operations ops = new Operations(ctx.client);
        ops.add(this.getAddress(), Values.empty().andOptional("profile", this.profile).andOptional("socket-binding-group", this.socketBindingGroup).andOptional("socket-binding-port-offset", this.socketBindingPortOffset));
    }

    public Address getAddress() {
        return Address.of((String)"server-group", (String)this.groupName);
    }

    public static final class Builder {
        private String groupName;
        private String profile;
        private String socketBindingGroup;
        private Integer socketBindingPortOffset;

        public Builder(String groupName, String profile, String socketBindingGroup) {
            if (groupName == null) {
                throw new IllegalArgumentException("Name of the group must be specified as non null value");
            }
            if (profile == null) {
                throw new IllegalArgumentException("profile must be specified as non null value");
            }
            if (socketBindingGroup == null) {
                throw new IllegalArgumentException("socketBindingGroup must be specified as non null value");
            }
            this.groupName = groupName;
            this.profile = profile;
            this.socketBindingGroup = socketBindingGroup;
        }

        public Builder socketBindingPortOffset(int socketBindingPortOffset) {
            this.socketBindingPortOffset = socketBindingPortOffset;
            return this;
        }

        public AddServerGroup build() {
            return new AddServerGroup(this);
        }
    }
}

