/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.creaper.commands.domain;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.creaper.core.CommandFailedException;
import org.jboss.creaper.core.online.OnlineCommand;
import org.jboss.creaper.core.online.OnlineCommandContext;
import org.jboss.creaper.core.online.operations.admin.DomainAdministration;

public final class ServersRunningStateBackup {
    private Map<String, List<String>> runningServersOnHosts;
    private final OnlineCommand backupPart = new OnlineCommand(){

        public void apply(OnlineCommandContext ctx) throws CommandFailedException, IOException {
            if (!ctx.options.isDomain) {
                throw new CommandFailedException(this.toString() + " only makes sense in domain");
            }
            if (ServersRunningStateBackup.this.runningServersOnHosts != null) {
                throw new CommandFailedException("Servers state was already backed up");
            }
            DomainAdministration domainAdministration = new DomainAdministration(ctx.client);
            HashMap<String, List> runningServers = new HashMap<String, List>();
            for (String host : domainAdministration.hosts()) {
                runningServers.put(host, domainAdministration.allRunningServers());
            }
            ServersRunningStateBackup.this.runningServersOnHosts = runningServers;
        }

        public String toString() {
            return "ServersRunningStateBackup.backup";
        }
    };
    private final OnlineCommand restorePart = new OnlineCommand(){

        public void apply(OnlineCommandContext ctx) throws CommandFailedException, IOException {
            if (!ctx.options.isDomain) {
                throw new CommandFailedException(this.toString() + " only makes sense in domain");
            }
            if (ServersRunningStateBackup.this.runningServersOnHosts == null) {
                throw new CommandFailedException("There is no servers state backup to restore");
            }
            DomainAdministration domainAdministration = new DomainAdministration(ctx.client);
            for (String host : domainAdministration.hosts()) {
                List servers = domainAdministration.allServers(host);
                for (String server : servers) {
                    if (ServersRunningStateBackup.this.runningServersOnHosts.containsKey(host) && ((List)ServersRunningStateBackup.this.runningServersOnHosts.get(host)).contains(server)) {
                        domainAdministration.startServer(host, server);
                        continue;
                    }
                    domainAdministration.stopServer(host, server);
                }
            }
            ServersRunningStateBackup.this.runningServersOnHosts = null;
        }

        public String toString() {
            return "ServersRunningStateBackup.restore";
        }
    };
    private final OnlineCommand destroyPart = new OnlineCommand(){

        public void apply(OnlineCommandContext ctx) throws CommandFailedException {
            if (!ctx.options.isDomain) {
                throw new CommandFailedException(this.toString() + " only makes sense in domain");
            }
            ServersRunningStateBackup.this.runningServersOnHosts = null;
        }

        public String toString() {
            return "ServersRunningStateBackup.destroy";
        }
    };

    public OnlineCommand backup() {
        return this.backupPart;
    }

    public OnlineCommand restore() {
        return this.restorePart;
    }

    public OnlineCommand destroy() {
        return this.destroyPart;
    }
}

