/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.creaper.commands.foundation.offline;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.jboss.creaper.core.CommandFailedException;
import org.jboss.creaper.core.offline.OfflineCommand;
import org.jboss.creaper.core.offline.OfflineCommandContext;
import org.jboss.logging.Logger;

public final class ConfigurationFileBackup {
    private static final Logger log = Logger.getLogger(ConfigurationFileBackup.class);
    private File backupFile;
    private final OfflineCommand backupPart = new OfflineCommand(){

        public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
            if (ConfigurationFileBackup.this.backupFile != null) {
                throw new CommandFailedException("Configuration file was already backed up to " + ConfigurationFileBackup.this.backupFile);
            }
            File tempFile = File.createTempFile("creaper-backup", null);
            Files.copy((File)ctx.configurationFile, (File)tempFile);
            ConfigurationFileBackup.this.backupFile = tempFile;
        }

        public String toString() {
            return "ConfigurationFileBackup.backup";
        }
    };
    private final OfflineCommand restorePart = new OfflineCommand(){

        public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
            if (ConfigurationFileBackup.this.backupFile == null) {
                throw new CommandFailedException("There's no configuration file backup to restore");
            }
            Files.copy((File)ConfigurationFileBackup.this.backupFile, (File)ctx.configurationFile);
            boolean deleted = ConfigurationFileBackup.this.backupFile.delete();
            if (!deleted) {
                log.errorf("Couldn't delete %s, continuing", (Object)ConfigurationFileBackup.this.backupFile);
            }
            ConfigurationFileBackup.this.backupFile = null;
        }

        public String toString() {
            return "ConfigurationFileBackup.restore";
        }
    };
    private final OfflineCommand destroyPart = new OfflineCommand(){

        public void apply(OfflineCommandContext ctx) {
            if (ConfigurationFileBackup.this.backupFile == null) {
                return;
            }
            boolean deleted = ConfigurationFileBackup.this.backupFile.delete();
            if (!deleted) {
                log.errorf("Couldn't delete %s, continuing", (Object)ConfigurationFileBackup.this.backupFile);
            }
            ConfigurationFileBackup.this.backupFile = null;
        }

        public String toString() {
            return "ConfigurationFileBackup.destroy";
        }
    };

    public OfflineCommand backup() {
        return this.backupPart;
    }

    public OfflineCommand restore() {
        return this.restorePart;
    }

    public OfflineCommand destroy() {
        return this.destroyPart;
    }
}

