/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.creaper.commands.foundation.online;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.jboss.creaper.core.CommandFailedException;
import org.jboss.creaper.core.online.CliException;
import org.jboss.creaper.core.online.OnlineCommand;
import org.jboss.creaper.core.online.OnlineCommandContext;

public final class CliFile
implements OnlineCommand {
    private final File file;
    private final Class clazz;

    public CliFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must be set");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File doesn't exist: " + file);
        }
        this.file = file;
        this.clazz = null;
    }

    public CliFile(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must be set");
        }
        this.file = null;
        this.clazz = clazz;
    }

    public void apply(OnlineCommandContext ctx) throws IOException, CliException, CommandFailedException {
        Object lines = new CliFileByteSource().asCharSource(Charsets.UTF_8).readLines();
        if (Iterables.any((Iterable)(lines = Iterables.filter((Iterable)lines, (Predicate)Predicates.not((Predicate)Predicates.containsPattern((String)"^\\s*connect\\s*$")))), (Predicate)Predicates.containsPattern((String)"^\\s*connect"))) {
            throw new CommandFailedException("The script contains an unsupported 'connect' operation: " + (this.file != null ? this.file : this.clazz.getSimpleName() + ".cli"));
        }
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            ctx.client.executeCli(line.trim());
        }
    }

    public String toString() {
        return "CliFile " + (this.file != null ? this.file : this.clazz.getSimpleName() + ".cli");
    }

    private final class CliFileByteSource
    extends ByteSource {
        private CliFileByteSource() {
        }

        public InputStream openStream() throws IOException {
            if (CliFile.this.file != null) {
                return new FileInputStream(CliFile.this.file);
            }
            return CliFile.this.clazz.getResourceAsStream(CliFile.this.clazz.getSimpleName() + ".cli");
        }
    }
}

