/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.creaper.commands.patching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.creaper.core.online.OnlineCommand;
import org.jboss.creaper.core.online.OnlineCommandContext;
import org.jboss.creaper.core.online.operations.Address;
import org.jboss.creaper.core.online.operations.Operations;
import org.jboss.creaper.core.online.operations.Values;

public final class RollbackPatch
implements OnlineCommand {
    private final String patchId;
    private final Boolean resetConfiguration;
    private final Boolean overrideAll;
    private final Boolean overrideModules;
    private final List<String> overridePaths;
    private final List<String> preservePaths;
    private final Boolean rollbackTo;

    private RollbackPatch(Builder builder) {
        this.patchId = builder.patchId;
        this.resetConfiguration = builder.resetConfiguration;
        this.overrideAll = builder.overrideAll;
        this.overrideModules = builder.overrideModules;
        this.overridePaths = builder.overridePaths;
        this.preservePaths = builder.preservePaths;
        this.rollbackTo = builder.rollbackTo;
    }

    public void apply(OnlineCommandContext ctx) throws IOException {
        Operations ops = new Operations(ctx.client);
        ops.invoke("rollback", Address.coreService((String)"patching"), Values.empty().andOptional("patch-id", this.patchId).andOptional("reset-configuration", this.resetConfiguration).andOptional("override-all", this.overrideAll).andOptional("override-modules", this.overrideModules).andListOptional(String.class, "override", this.overridePaths).andListOptional(String.class, "preserve", this.preservePaths).andOptional("rollback-to", this.rollbackTo));
    }

    public String toString() {
        return "RollbackPatch " + this.patchId;
    }

    public static final class Builder {
        private final String patchId;
        private Boolean resetConfiguration;
        private Boolean overrideAll;
        private Boolean overrideModules;
        private List<String> overridePaths;
        private List<String> preservePaths;
        private Boolean rollbackTo;

        public Builder(String patchId) {
            this.patchId = patchId;
        }

        public Builder resetConfiguration(boolean resetConfiguration) {
            this.resetConfiguration = resetConfiguration;
            return this;
        }

        public Builder rollbackTo(boolean rollbackTo) {
            this.rollbackTo = rollbackTo;
            return this;
        }

        public Builder overrideAll(boolean overrideAll) {
            this.overrideAll = overrideAll;
            return this;
        }

        public Builder overrideModules(boolean overrideModules) {
            this.overrideModules = overrideModules;
            return this;
        }

        public Builder overridePaths(String ... pathsToOverride) {
            if (this.overridePaths == null && pathsToOverride != null) {
                this.overridePaths = new ArrayList<String>();
            }
            if (pathsToOverride != null) {
                this.overridePaths.addAll(Arrays.asList(pathsToOverride));
            }
            return this;
        }

        public Builder preservePaths(String ... pathsToPreserve) {
            if (this.preservePaths == null && pathsToPreserve != null) {
                this.preservePaths = new ArrayList<String>();
            }
            if (pathsToPreserve != null) {
                this.preservePaths.addAll(Arrays.asList(pathsToPreserve));
            }
            return this;
        }

        public RollbackPatch build() {
            return new RollbackPatch(this);
        }
    }
}

