/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.creaper.commands.undertow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.creaper.core.online.OnlineCommand;
import org.jboss.creaper.core.online.OnlineCommandContext;
import org.jboss.creaper.core.online.operations.Address;
import org.jboss.creaper.core.online.operations.Batch;
import org.jboss.creaper.core.online.operations.Operations;
import org.jboss.creaper.core.online.operations.Values;

public final class AddHttpsSecurityRealm
implements OnlineCommand {
    private final String securityRealmName;
    private final String keystorePassword;
    private final String alias;
    private final List<String> enabledCipherSuites;
    private final List<String> enabledProtocols;
    private final String keyPassword;
    private final String keystorePath;
    private final String keystoreProvider;
    private final String keystoreRelativeTo;
    private final String protocol;
    private final String truststorePassword;
    private final String truststorePath;
    private final String truststoreProvider;
    private final String truststoreRelativeTo;

    private AddHttpsSecurityRealm(Builder builder) {
        this.securityRealmName = builder.securityRealmName;
        this.keystorePassword = builder.keystorePassword;
        this.alias = builder.alias;
        this.enabledCipherSuites = builder.enabledCipherSuites;
        this.enabledProtocols = builder.enabledProtocols;
        this.keyPassword = builder.keyPassword;
        this.keystorePath = builder.keystorePath;
        this.keystoreProvider = builder.keystoreProvider;
        this.keystoreRelativeTo = builder.keystoreRelativeTo;
        this.protocol = builder.protocol;
        this.truststorePassword = builder.truststorePassword;
        this.truststorePath = builder.truststorePath;
        this.truststoreProvider = builder.truststoreProvider;
        this.truststoreRelativeTo = builder.truststoreRelativeTo;
    }

    public void apply(OnlineCommandContext ctx) throws IOException {
        Address securityRealmAddress = Address.coreService((String)"management").and("security-realm", this.securityRealmName);
        Operations ops = new Operations(ctx.client);
        Batch batch = new Batch();
        batch.add(securityRealmAddress);
        batch.add(securityRealmAddress.and("server-identity", "ssl"), Values.empty().andOptional("alias", this.alias).andListOptional(String.class, "enabled-cipher-suites", this.enabledCipherSuites).andListOptional(String.class, "enabled-protocols", this.enabledProtocols).andOptional("key-password", this.keyPassword).and("keystore-password", this.keystorePassword).andOptional("keystore-path", this.keystorePath).andOptional("keystore-provider", this.keystoreProvider).andOptional("keystore-relative-to", this.keystoreRelativeTo).andOptional("protocol", this.protocol));
        batch.add(securityRealmAddress.and("authentication", "truststore"), Values.empty().and("keystore-password", this.truststorePassword).andOptional("keystore-path", this.truststorePath).andOptional("keystore-provider", this.truststoreProvider).andOptional("keystore-relative-to", this.truststoreRelativeTo));
        ops.batch(batch);
    }

    public static final class Builder {
        private final String securityRealmName;
        private String keystorePassword;
        private String alias;
        private List<String> enabledCipherSuites;
        private List<String> enabledProtocols;
        private String keyPassword;
        private String keystorePath;
        private String keystoreProvider;
        private String keystoreRelativeTo;
        private String protocol;
        private String truststorePassword;
        private String truststorePath;
        private String truststoreProvider;
        private String truststoreRelativeTo;

        public Builder(String securityRealmName) {
            this.securityRealmName = securityRealmName;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder cipherSuitesToEnable(String ... cipherSuitesToEnable) {
            if (this.enabledCipherSuites == null && cipherSuitesToEnable != null) {
                this.enabledCipherSuites = new ArrayList<String>();
            }
            if (cipherSuitesToEnable != null) {
                this.enabledCipherSuites.addAll(Arrays.asList(cipherSuitesToEnable));
            }
            return this;
        }

        public Builder protocolsToEnable(String ... protocolsToEnable) {
            if (this.enabledProtocols == null && protocolsToEnable != null) {
                this.enabledProtocols = new ArrayList<String>();
            }
            if (protocolsToEnable != null) {
                this.enabledProtocols.addAll(Arrays.asList(protocolsToEnable));
            }
            return this;
        }

        public Builder keystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public Builder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder keystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        public Builder keystoreProvider(String keystoreProvider) {
            this.keystoreProvider = keystoreProvider;
            return this;
        }

        public Builder keystoreRelativeTo(String keystoreRelativeTo) {
            this.keystoreRelativeTo = keystoreRelativeTo;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder truststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
            return this;
        }

        public Builder truststorePath(String truststorePath) {
            this.truststorePath = truststorePath;
            return this;
        }

        public Builder truststoreProvider(String truststoreProvider) {
            this.truststoreProvider = truststoreProvider;
            return this;
        }

        public Builder truststoreRelativeTo(String truststoreRelativeTo) {
            this.truststoreRelativeTo = truststoreRelativeTo;
            return this;
        }

        public AddHttpsSecurityRealm build() {
            return new AddHttpsSecurityRealm(this);
        }
    }
}

