/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.creaper.commands.undertow;

import java.io.IOException;
import org.jboss.creaper.commands.undertow.SslVerifyClient;
import org.jboss.creaper.commands.undertow.UndertowListenerType;
import org.jboss.creaper.core.CommandFailedException;
import org.jboss.creaper.core.ManagementVersion;
import org.jboss.creaper.core.online.OnlineCommand;
import org.jboss.creaper.core.online.OnlineCommandContext;
import org.jboss.creaper.core.online.operations.Address;
import org.jboss.creaper.core.online.operations.Operations;
import org.jboss.creaper.core.online.operations.Values;

public final class AddUndertowListener
implements OnlineCommand {
    private final UndertowListenerType listenerType;
    private String listenerName;
    private String serverName;
    private Boolean allowEncodedSlash;
    private Boolean allowEqualsInCookiesValues;
    private Boolean alwaysSetKeepAlive;
    private Boolean bufferPipelinedData;
    private String bufferPool;
    private Boolean decodeUrl;
    private Boolean enabled;
    private Integer maxBufferedRequestSize;
    private Integer maxCookies;
    private Integer maxHeaderSize;
    private Integer maxHeaders;
    private Integer maxParameters;
    private Long maxPostSize;
    private Integer noRequestTimeout;
    private Integer readTimeout;
    private Integer receiveBuffer;
    private Boolean recordRequestStartTime;
    private Integer requestParseTimeout;
    private Boolean resolvePeerAddress;
    private Integer sendBuffer;
    private String socketBinding;
    private Integer tcpBacklog;
    private Boolean tcpKeepAlive;
    private String urlCharset;
    private String worker;
    private Integer writeTimeout;
    private Boolean certificateForwarding;
    private Boolean proxyAddressForwarding;
    private Boolean enableHttp2;
    private String redirectSocket;
    private Boolean enableSpdy;
    private String enabledCipherSuites;
    private String enabledProtocols;
    private String securityRealm;
    private SslVerifyClient verifyClient;
    private String scheme;

    private AddUndertowListener(HttpBuilder builder) {
        this.listenerType = UndertowListenerType.HTTP_LISTENER;
        this.certificateForwarding = builder.certificateForwarding;
        this.proxyAddressForwarding = builder.proxyAddressForwarding;
        this.redirectSocket = builder.redirectSocket;
        this.enableHttp2 = builder.enableHttp2;
        this.initCommonOptions(builder);
    }

    private AddUndertowListener(HttpsBuilder builder) {
        this.listenerType = UndertowListenerType.HTTPS_LISTENER;
        this.enableHttp2 = builder.enableHttp2;
        this.enableSpdy = builder.enableSpdy;
        this.enabledCipherSuites = builder.enabledCipherSuites;
        this.enabledProtocols = builder.enabledProtocols;
        this.securityRealm = builder.securityRealm;
        this.verifyClient = builder.verifyClient;
        this.initCommonOptions(builder);
    }

    private AddUndertowListener(AjpBuilder builder) {
        this.listenerType = UndertowListenerType.AJP_LISTENER;
        this.scheme = builder.scheme;
        this.redirectSocket = builder.redirectSocket;
        this.initCommonOptions(builder);
    }

    private void initCommonOptions(UndertowListenerBuilder builder) {
        this.serverName = builder.serverName;
        this.listenerName = builder.listenerName;
        this.allowEncodedSlash = builder.allowEncodedSlash;
        this.allowEqualsInCookiesValues = builder.allowEqualsInCookiesValues;
        this.alwaysSetKeepAlive = builder.alwaysSetKeepAlive;
        this.bufferPipelinedData = builder.bufferPipelinedData;
        this.bufferPool = builder.bufferPool;
        this.decodeUrl = builder.decodeUrl;
        this.enabled = builder.enabled;
        this.maxBufferedRequestSize = builder.maxBufferedRequestSize;
        this.maxCookies = builder.maxCookies;
        this.maxHeaderSize = builder.maxHeaderSize;
        this.maxHeaders = builder.maxHeaders;
        this.maxParameters = builder.maxParameters;
        this.maxPostSize = builder.maxPostSize;
        this.noRequestTimeout = builder.noRequestTimeout;
        this.readTimeout = builder.readTimeout;
        this.receiveBuffer = builder.receiveBuffer;
        this.recordRequestStartTime = builder.recordRequestStartTime;
        this.requestParseTimeout = builder.requestParseTimeout;
        this.resolvePeerAddress = builder.resolvePeerAddress;
        this.sendBuffer = builder.sendBuffer;
        this.socketBinding = builder.socketBinding;
        this.tcpBacklog = builder.tcpBacklog;
        this.tcpKeepAlive = builder.tcpKeepAlive;
        this.urlCharset = builder.urlCharset;
        this.worker = builder.worker;
        this.writeTimeout = builder.writeTimeout;
    }

    public void apply(OnlineCommandContext ctx) throws CommandFailedException, IOException {
        ctx.serverVersion.assertAtLeast(ManagementVersion.VERSION_3_0_0);
        Operations ops = new Operations(ctx.client);
        Address listenerAddress = Address.subsystem((String)"undertow").and("server", this.serverName).and(this.listenerType.listenerTypeName(), this.listenerName);
        Values params = Values.empty().andOptional("allow-encoded-slash", this.allowEncodedSlash).andOptional("allow-equals-in-cookie-value", this.allowEqualsInCookiesValues).andOptional("always-set-keep-alive", this.alwaysSetKeepAlive).andOptional("buffer-pipelined-data", this.bufferPipelinedData).andOptional("buffer-pool", this.bufferPool).andOptional("decode-url", this.decodeUrl).andOptional("enabled", this.enabled).andOptional("max-buffered-request-size", this.maxBufferedRequestSize).andOptional("max-cookies", this.maxCookies).andOptional("max-header-size", this.maxHeaderSize).andOptional("max-headers", this.maxHeaders).andOptional("max-parameters", this.maxParameters).andOptional("max-post-size", this.maxPostSize).andOptional("no-request-timeout", this.noRequestTimeout).andOptional("read-timeout", this.readTimeout).andOptional("receive-buffer", this.receiveBuffer).andOptional("record-request-start-time", this.recordRequestStartTime).andOptional("request-parse-timeout", this.requestParseTimeout).andOptional("resolve-peer-address", this.resolvePeerAddress).andOptional("send-buffer", this.sendBuffer).and("socket-binding", this.socketBinding).andOptional("tcp-backlog", this.tcpBacklog).andOptional("tcp-keep-alive", this.tcpKeepAlive).andOptional("url-charset", this.urlCharset).andOptional("worker", this.worker).andOptional("write-timeout", this.writeTimeout);
        if (this.listenerType == UndertowListenerType.HTTP_LISTENER || this.listenerType == UndertowListenerType.AJP_LISTENER) {
            params = params.andOptional("redirect-socket", this.redirectSocket);
        }
        if (this.listenerType == UndertowListenerType.HTTPS_LISTENER || this.listenerType == UndertowListenerType.HTTP_LISTENER) {
            params = params.andOptional("enable-http2", this.enableHttp2);
        }
        switch (this.listenerType) {
            case HTTP_LISTENER: {
                params = params.andOptional("certificate-forwarding", this.certificateForwarding).andOptional("proxy-address-forwarding", this.proxyAddressForwarding);
                break;
            }
            case HTTPS_LISTENER: {
                params = params.andOptional("enable-spdy", this.enableSpdy).andOptional("enabled-cipher-suites", this.enabledCipherSuites).andOptional("enabled-protocols", this.enabledProtocols).and("security-realm", this.securityRealm).andOptional("verify-client", this.verifyClient != null ? this.verifyClient.name() : null);
                break;
            }
            case AJP_LISTENER: {
                params = params.andOptional("scheme", this.scheme);
                break;
            }
            default: {
                throw new CommandFailedException("Unknown listener type");
            }
        }
        ops.add(listenerAddress, params);
    }

    public String toString() {
        return "AddUndertowListener " + this.listenerName + " of type " + this.listenerType.listenerTypeName() + " for server " + this.serverName;
    }

    public static final class AjpBuilder
    extends UndertowListenerBuilder<AjpBuilder> {
        private String redirectSocket;
        private String scheme;

        public AjpBuilder(String listenerName, String serverName, String socketBinding) {
            super(listenerName, serverName, socketBinding);
        }

        public AjpBuilder(String listenerName, String socketBinding) {
            super(listenerName, socketBinding);
        }

        public AjpBuilder(String listenerName) {
            super(listenerName, "ajp");
        }

        public AjpBuilder redirectSocket(String redirectSocket) {
            this.redirectSocket = redirectSocket;
            return this;
        }

        public AjpBuilder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public AddUndertowListener build() {
            return new AddUndertowListener(this);
        }
    }

    public static final class HttpsBuilder
    extends UndertowListenerBuilder<HttpsBuilder> {
        private Boolean enableHttp2;
        private Boolean enableSpdy;
        private String enabledCipherSuites;
        private String enabledProtocols;
        private String securityRealm;
        private SslVerifyClient verifyClient;

        public HttpsBuilder(String listenerName, String serverName, String socketBinding) {
            super(listenerName, serverName, socketBinding);
        }

        public HttpsBuilder(String listenerName, String socketBinding) {
            super(listenerName, socketBinding);
        }

        public HttpsBuilder(String listenerName) {
            super(listenerName, "https");
        }

        public HttpsBuilder enableHttp2(boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
            return this;
        }

        public HttpsBuilder enableSpdy(boolean enableSpdy) {
            this.enableSpdy = enableSpdy;
            return this;
        }

        public HttpsBuilder enabledCipherSuites(String enabledCipherSuites) {
            this.enabledCipherSuites = enabledCipherSuites;
            return this;
        }

        public HttpsBuilder enabledProtocols(String enabledProtocols) {
            this.enabledProtocols = enabledProtocols;
            return this;
        }

        public HttpsBuilder securityRealm(String securityRealm) {
            this.securityRealm = securityRealm;
            return this;
        }

        public HttpsBuilder verifyClient(SslVerifyClient sslVerifyClient) {
            this.verifyClient = sslVerifyClient;
            return this;
        }

        public AddUndertowListener build() {
            return new AddUndertowListener(this);
        }
    }

    public static final class HttpBuilder
    extends UndertowListenerBuilder<HttpBuilder> {
        private Boolean certificateForwarding;
        private Boolean proxyAddressForwarding;
        private String redirectSocket;
        private Boolean enableHttp2;

        public HttpBuilder(String listenerName, String serverName, String socketBinding) {
            super(listenerName, serverName, socketBinding);
        }

        public HttpBuilder(String listenerName, String socketBinding) {
            super(listenerName, socketBinding);
        }

        public HttpBuilder(String listenerName) {
            super(listenerName, "http");
        }

        public HttpBuilder enableHttp2(boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
            return this;
        }

        public HttpBuilder certificateForwarding(boolean certificateForwarding) {
            this.certificateForwarding = certificateForwarding;
            return this;
        }

        public HttpBuilder proxyAddressForwarding(Boolean proxyAddressForwarding) {
            this.proxyAddressForwarding = proxyAddressForwarding;
            return this;
        }

        public HttpBuilder redirectSocket(String redirectSocket) {
            this.redirectSocket = redirectSocket;
            return this;
        }

        public AddUndertowListener build() {
            return new AddUndertowListener(this);
        }
    }

    static abstract class UndertowListenerBuilder<THIS extends UndertowListenerBuilder<THIS>> {
        protected final String listenerName;
        protected final String serverName;
        protected Boolean allowEncodedSlash;
        protected Boolean allowEqualsInCookiesValues;
        protected Boolean alwaysSetKeepAlive;
        protected Boolean bufferPipelinedData;
        protected String bufferPool;
        protected Boolean decodeUrl;
        protected Boolean enabled;
        protected Integer maxBufferedRequestSize;
        protected Integer maxCookies;
        protected Integer maxHeaderSize;
        protected Integer maxHeaders;
        protected Integer maxParameters;
        protected Long maxPostSize;
        protected Integer noRequestTimeout;
        protected Integer readTimeout;
        protected Integer receiveBuffer;
        protected Boolean recordRequestStartTime;
        protected Integer requestParseTimeout;
        protected Boolean resolvePeerAddress;
        protected Integer sendBuffer;
        protected String socketBinding;
        protected Integer tcpBacklog;
        protected Boolean tcpKeepAlive;
        protected String urlCharset;
        protected String worker;
        protected Integer writeTimeout;

        public UndertowListenerBuilder(String listenerName, String serverName, String socketBinding) {
            if (listenerName == null) {
                throw new IllegalArgumentException("Name of the listener must be specified as non null value");
            }
            if (serverName == null) {
                throw new IllegalArgumentException("Name of the undertow server must be specified as non null value");
            }
            if (socketBinding == null) {
                throw new IllegalArgumentException("The socket binding must be specified as non null value");
            }
            this.socketBinding = socketBinding;
            this.listenerName = listenerName;
            this.serverName = serverName;
        }

        public UndertowListenerBuilder(String listenerName, String socketBinding) {
            if (listenerName == null) {
                throw new IllegalArgumentException("Name of the listener must be specified as non null value");
            }
            if (socketBinding == null) {
                throw new IllegalArgumentException("The socket binding must be specified as non null value");
            }
            this.listenerName = listenerName;
            this.socketBinding = socketBinding;
            this.serverName = "default-server";
        }

        public final THIS allowEncodedSlash(boolean allowEncodedSlash) {
            this.allowEncodedSlash = allowEncodedSlash;
            return (THIS)this;
        }

        public THIS allowEqualsInCookiesValues(boolean allowEqualsInCookiesValues) {
            this.allowEqualsInCookiesValues = allowEqualsInCookiesValues;
            return (THIS)this;
        }

        public THIS alwaysSetKeepAlive(boolean alwaysSetKeepAlive) {
            this.alwaysSetKeepAlive = alwaysSetKeepAlive;
            return (THIS)this;
        }

        public THIS bufferPipelinedData(boolean bufferPipelinedData) {
            this.bufferPipelinedData = bufferPipelinedData;
            return (THIS)this;
        }

        public THIS bufferPool(String bufferPool) {
            this.bufferPool = bufferPool;
            return (THIS)this;
        }

        public THIS decodeUrl(boolean decodeUrl) {
            this.decodeUrl = decodeUrl;
            return (THIS)this;
        }

        public THIS enabled(boolean enabled) {
            this.enabled = enabled;
            return (THIS)this;
        }

        public THIS maxBufferedRequestSize(int maxBufferedRequestSize) {
            this.maxBufferedRequestSize = maxBufferedRequestSize;
            return (THIS)this;
        }

        public THIS maxCookies(int maxCookies) {
            this.maxCookies = maxCookies;
            return (THIS)this;
        }

        public THIS maxHeaderSize(int maxHeaderSize) {
            this.maxHeaderSize = maxHeaderSize;
            return (THIS)this;
        }

        public THIS maxHeaders(int maxHeaders) {
            this.maxHeaders = maxHeaders;
            return (THIS)this;
        }

        public THIS maxParameters(int maxParameters) {
            this.maxParameters = maxParameters;
            return (THIS)this;
        }

        public THIS maxPostSize(long maxPostSize) {
            this.maxPostSize = maxPostSize;
            return (THIS)this;
        }

        public THIS noRequestTimeout(int noRequestTimeout) {
            this.noRequestTimeout = noRequestTimeout;
            return (THIS)this;
        }

        public THIS readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return (THIS)this;
        }

        public THIS receiveBuffer(int receiveBuffer) {
            this.receiveBuffer = receiveBuffer;
            return (THIS)this;
        }

        public THIS recordRequestStartTime(boolean recordRequestStartTime) {
            this.recordRequestStartTime = recordRequestStartTime;
            return (THIS)this;
        }

        public THIS requestParseTimeout(int requestParseTimeout) {
            this.requestParseTimeout = requestParseTimeout;
            return (THIS)this;
        }

        public THIS resolvePeerAddress(boolean resolvePeerAddress) {
            this.resolvePeerAddress = resolvePeerAddress;
            return (THIS)this;
        }

        public THIS sendBuffer(int sendBuffer) {
            this.sendBuffer = sendBuffer;
            return (THIS)this;
        }

        public THIS tcpBacklog(int tcpBacklog) {
            this.tcpBacklog = tcpBacklog;
            return (THIS)this;
        }

        public THIS tcpKeepAlive(boolean tcpKeepAlive) {
            this.tcpKeepAlive = tcpKeepAlive;
            return (THIS)this;
        }

        public THIS urlCharset(String urlCharset) {
            this.urlCharset = urlCharset;
            return (THIS)this;
        }

        public THIS worker(String worker) {
            this.worker = worker;
            return (THIS)this;
        }

        public THIS writeTimeout(int writeTimeout) {
            this.writeTimeout = writeTimeout;
            return (THIS)this;
        }
    }
}

