/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.creaper.commands.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.jboss.creaper.commands.foundation.offline.xml.Subtree;
import org.jboss.creaper.core.CommandFailedException;
import org.jboss.creaper.core.offline.OfflineCommand;
import org.jboss.creaper.core.offline.OfflineCommandContext;
import org.jboss.creaper.core.online.OnlineCommand;
import org.jboss.creaper.core.online.OnlineCommandContext;
import org.jboss.creaper.core.online.operations.Address;
import org.jboss.creaper.core.online.operations.OperationException;
import org.jboss.creaper.core.online.operations.Operations;
import org.jboss.creaper.core.online.operations.Values;

public final class AddConnector
implements OnlineCommand,
OfflineCommand {
    private final String connectorName;
    private final Boolean enableLookups;
    private final Boolean enabled;
    private final String executor;
    private final Integer maxConnections;
    private final Integer maxPostSize;
    private final Integer maxSavePostSize;
    private final String protocol;
    private final String proxyBinding;
    private final String proxyName;
    private final Integer proxyPort;
    private final String redirectBinding;
    private final Integer redirectPort;
    private final Boolean secure;
    private final String scheme;
    private final String socketBinding;
    private final List<String> virtualServers;
    private final boolean replaceExisting;

    private AddConnector(Builder builder) {
        this.connectorName = builder.connectorName;
        this.enableLookups = builder.enableLookups;
        this.enabled = builder.enabled;
        this.executor = builder.executor;
        this.maxConnections = builder.maxConnections;
        this.maxPostSize = builder.maxPostSize;
        this.maxSavePostSize = builder.maxSavePostSize;
        this.protocol = builder.protocol;
        this.proxyBinding = builder.proxyBinding;
        this.proxyName = builder.proxyName;
        this.proxyPort = builder.proxyPort;
        this.redirectBinding = builder.redirectBinding;
        this.redirectPort = builder.redirectPort;
        this.secure = builder.secure;
        this.scheme = builder.scheme;
        this.socketBinding = builder.socketBinding;
        this.virtualServers = builder.virtualServers;
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws IOException {
        Operations ops = new Operations(ctx.client);
        Address connectorAddress = Address.subsystem((String)"web").and("connector", this.connectorName);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(connectorAddress);
            }
            catch (OperationException e) {
                throw new IOException("Failed to remove existing datasource " + this.connectorName, e);
            }
        }
        ops.add(connectorAddress, Values.empty().andOptional("name", this.connectorName).andOptional("enable-lookups", this.enableLookups).andOptional("enabled", this.enabled).andOptional("executor", this.executor).andOptional("max-connections", this.maxConnections).andOptional("max-post-size", this.maxPostSize).andOptional("max-save-post-size", this.maxSavePostSize).andOptional("protocol", this.protocol).andOptional("proxy-binding", this.proxyBinding).andOptional("proxy-name", this.proxyName).andOptional("proxy-port", this.proxyPort).andOptional("redirect-binding", this.redirectBinding).andOptional("redirect-port", this.redirectPort).andOptional("secure", this.secure).andOptional("scheme", this.scheme).andOptional("socket-binding", this.socketBinding).andListOptional(String.class, "virtual-server", this.virtualServers));
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
        GroovyXmlTransform connector = GroovyXmlTransform.of(AddConnector.class).subtree("web", Subtree.subsystem("web")).parameter("connectorName", this.connectorName).parameter("enableLookups", this.enableLookups).parameter("enabled", this.enabled).parameter("executor", this.executor).parameter("maxConnections", this.maxConnections).parameter("maxPostSize", this.maxPostSize).parameter("maxSavePostSize", this.maxSavePostSize).parameter("protocol", this.protocol).parameter("proxyBinding", this.proxyBinding).parameter("proxyName", this.proxyName).parameter("proxyPort", this.proxyPort).parameter("redirectBinding", this.redirectBinding).parameter("redirectPort", this.redirectPort).parameter("secure", this.secure).parameter("scheme", this.scheme).parameter("socketBinding", this.socketBinding).parameter("virtualServers", this.virtualServers).parameter("replaceExisting", this.replaceExisting).build();
        ctx.client.apply(new OfflineCommand[]{connector});
    }

    public String toString() {
        return "AddConnector " + this.connectorName;
    }

    public static final class Builder {
        private final String connectorName;
        private Boolean enableLookups;
        private Boolean enabled;
        private String executor;
        private Integer maxConnections;
        private Integer maxPostSize;
        private Integer maxSavePostSize;
        private String protocol;
        private String proxyBinding;
        private String proxyName;
        private Integer proxyPort;
        private String redirectBinding;
        private Integer redirectPort;
        private Boolean secure;
        private String scheme;
        private String socketBinding;
        private List<String> virtualServers;
        private boolean replaceExisting = false;

        public Builder(String connectorName) {
            if (connectorName == null) {
                throw new IllegalArgumentException("Name of the connector must be specified as non null value");
            }
            this.connectorName = connectorName;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public Builder enableLookups(Boolean enableLookups) {
            this.enableLookups = enableLookups;
            return this;
        }

        public Builder enabled(Boolean enable) {
            this.enabled = enable;
            return this;
        }

        public Builder executor(String executor) {
            this.executor = executor;
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder maxPostSize(Integer maxPostSize) {
            this.maxPostSize = maxPostSize;
            return this;
        }

        public Builder maxSavePostSize(Integer maxSavePostSize) {
            this.maxSavePostSize = maxSavePostSize;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder proxyBinding(String proxyBinding) {
            this.proxyBinding = proxyBinding;
            return this;
        }

        public Builder proxyName(String proxyName) {
            this.proxyName = proxyName;
            return this;
        }

        public Builder proxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder redirectBinding(String redirectBinding) {
            this.redirectBinding = redirectBinding;
            return this;
        }

        public Builder redirectPort(Integer redirectPort) {
            this.redirectPort = redirectPort;
            return this;
        }

        public Builder secure(Boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder socketBinding(String socketBinding) {
            this.socketBinding = socketBinding;
            return this;
        }

        public Builder virtualServer(String ... virtualServers) {
            if (this.virtualServers == null && virtualServers != null) {
                this.virtualServers = new ArrayList<String>();
            }
            if (virtualServers != null) {
                this.virtualServers.addAll(Arrays.asList(virtualServers));
            }
            return this;
        }

        public AddConnector build() {
            return new AddConnector(this);
        }
    }
}

