/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.dashboard.annotation.Destroyable;
import org.jboss.dashboard.commons.comparator.ComparatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestroyableProcessor {
    private static transient Logger log = LoggerFactory.getLogger((String)DestroyableProcessor.class.getName());
    @Inject
    protected Instance<Destroyable> destroyables;
    private final DestroyableComparator destroyableComparator = new DestroyableComparator();

    public void destroyBeans() {
        ArrayList<Destroyable> destroyableList = new ArrayList<Destroyable>();
        for (Destroyable destroyable : this.destroyables) {
            destroyableList.add(destroyable);
        }
        Collections.sort(destroyableList, this.destroyableComparator);
        for (Destroyable destroyable : destroyableList) {
            try {
                log.debug("Destroying " + (Object)((Object)destroyable.getPriority()) + " priority bean " + destroyable.getClass().getName());
                destroyable.destroy();
            }
            catch (Exception e) {
                log.error("Error destroying bean " + destroyable.getClass().getName(), (Throwable)e);
            }
        }
    }

    private class DestroyableComparator
    implements Comparator {
        private DestroyableComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                Destroyable s1 = (Destroyable)o1;
                Destroyable s2 = (Destroyable)o2;
                return ComparatorUtils.compare(Integer.valueOf(s1.getPriority().getWeight()), Integer.valueOf(s2.getPriority().getWeight()), -1);
            }
            catch (ClassCastException e) {
                return 0;
            }
        }
    }
}

