/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.factory;

import org.jboss.dashboard.factory.Component;
import org.jboss.dashboard.factory.PropertyChangeProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyAddProcessingInstruction
extends PropertyChangeProcessingInstruction {
    private static transient Logger log = LoggerFactory.getLogger((String)PropertyAddProcessingInstruction.class.getName());

    public PropertyAddProcessingInstruction(Component component, String propertyName, String propertyValue) {
        super(component, propertyName, propertyValue);
    }

    @Override
    public Object getValueAfterChange(Object originalValue, Class expectedClass) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Processing instruction " + this + " on value " + originalValue + " (" + expectedClass + ")");
        }
        Object valueToAdd = null;
        Object currentValue = originalValue;
        currentValue = currentValue == null ? this.getNewInstanceForClass(expectedClass) : currentValue;
        valueToAdd = this.getValueForParameter(this.getPropertyValue(), expectedClass);
        if (valueToAdd != null) {
            if (expectedClass.isArray()) {
                Object newValue = this.getBaseArray(expectedClass.getComponentType(), ((Object[])currentValue).length + ((Object[])valueToAdd).length);
                System.arraycopy(currentValue, 0, newValue, 0, ((Object[])currentValue).length);
                System.arraycopy(valueToAdd, 0, newValue, ((Object[])currentValue).length, ((Object[])valueToAdd).length);
                return newValue;
            }
            if (String.class.equals((Object)expectedClass)) {
                return (String)currentValue + (String)valueToAdd;
            }
            if (expectedClass.equals(Integer.TYPE)) {
                return new Integer((Integer)currentValue + (Integer)valueToAdd);
            }
            if (expectedClass.equals(Long.TYPE)) {
                return new Long((Long)currentValue + (Long)valueToAdd);
            }
            if (expectedClass.equals(Double.TYPE)) {
                return new Double((Double)currentValue + (Double)valueToAdd);
            }
            if (expectedClass.equals(Float.TYPE)) {
                return new Float(((Float)currentValue).floatValue() + ((Float)valueToAdd).floatValue());
            }
            if (expectedClass.equals(Byte.TYPE)) {
                return new Byte((byte)((Byte)currentValue + (Byte)valueToAdd));
            }
            if (expectedClass.equals(Short.TYPE)) {
                return new Short((short)((Short)currentValue + (Short)valueToAdd));
            }
            if (expectedClass.equals(Integer.class)) {
                return new Integer((Integer)currentValue + (Integer)valueToAdd);
            }
            if (expectedClass.equals(Long.class)) {
                return new Long((Long)currentValue + (Long)valueToAdd);
            }
            if (expectedClass.equals(Double.class)) {
                return new Double((Double)currentValue + (Double)valueToAdd);
            }
            if (expectedClass.equals(Float.class)) {
                return new Float(((Float)currentValue).floatValue() + ((Float)valueToAdd).floatValue());
            }
            if (expectedClass.equals(Byte.class)) {
                return new Byte((byte)((Byte)currentValue + (Byte)valueToAdd));
            }
            if (expectedClass.equals(Short.class)) {
                return new Short((short)((Short)currentValue + (Short)valueToAdd));
            }
            log.error("Addition not supported for class " + expectedClass + ". Ignoring property " + this.getPropertyName() + "+=" + this.getPropertyValue());
        }
        return originalValue;
    }

    public String toString() {
        return "do{" + this.getPropertyName() + "+=" + this.getPropertyValue() + "}";
    }
}

