/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.profiler;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.commons.misc.Chronometer;
import org.jboss.dashboard.error.ErrorReport;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.CodeBlockTraces;
import org.jboss.dashboard.profiler.ThreadProfile;
import org.jboss.dashboard.profiler.ThreadProfileComparator;
import org.jboss.dashboard.profiler.ThreadProfileFilter;
import org.jboss.dashboard.profiler.memory.LowMemoryConstraints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="profiler")
public class Profiler
implements Runnable {
    private static transient Logger log = LoggerFactory.getLogger((String)Profiler.class.getName());
    @Inject
    @Config(value="100")
    protected long idleTimeInMillis = 100L;
    @Inject
    @Config(value="false")
    protected boolean runOnStart = false;
    @Inject
    @Config(value="300000")
    protected long maxThreadProfilingTimeMillis = 300000L;
    @Inject
    @Config(value="500")
    protected int maxThreadStackTraceLength = 500;
    @Inject
    @Config(value="10")
    protected long minCodeTraceTimeMillis = 10L;
    @Inject
    @Config(value="100")
    protected int completedThreadsMaxSize = 100;
    @Inject
    @Config(value="60000")
    protected long completedThreadsMinTimeMillis = 60000L;
    @Inject
    @Config(value="true")
    protected boolean completedThreadsErrorsEnabled = true;
    protected Thread profilerThread;
    protected transient boolean running = false;
    protected List<ThreadProfile> activeThreads = new ArrayList<ThreadProfile>();
    protected List<ThreadProfile> completedThreads = new ArrayList<ThreadProfile>();
    protected ThreadProfileFilter completedThreadsFilter = new ThreadProfileFilter();
    protected ThreadLocal<ThreadProfile> currentThreadProfile = new ThreadLocal();
    @Inject
    protected LowMemoryConstraints lowMemoryConstraints;

    public static Profiler lookup() {
        return CDIBeanLocator.getBeanByType(Profiler.class);
    }

    public boolean isRunOnStart() {
        return this.runOnStart;
    }

    public void setRunOnStart(boolean runOnStart) {
        this.runOnStart = runOnStart;
    }

    public long getIdleTimeInMillis() {
        return this.idleTimeInMillis;
    }

    public void setIdleTimeInMillis(long idleTimeInMillis) {
        this.idleTimeInMillis = idleTimeInMillis;
    }

    public long getMaxThreadProfilingTimeMillis() {
        return this.maxThreadProfilingTimeMillis;
    }

    public void setMaxThreadProfilingTimeMillis(long maxThreadProfilingTimeMillis) {
        this.maxThreadProfilingTimeMillis = maxThreadProfilingTimeMillis;
    }

    public int getMaxThreadStackTraceLength() {
        return this.maxThreadStackTraceLength;
    }

    public void setMaxThreadStackTraceLength(int maxThreadStackTraceLength) {
        this.maxThreadStackTraceLength = maxThreadStackTraceLength;
    }

    public int getCompletedThreadsMaxSize() {
        return this.completedThreadsMaxSize;
    }

    public void setCompletedThreadsMaxSize(int completedThreadsMaxSize) {
        this.completedThreadsMaxSize = completedThreadsMaxSize;
    }

    public boolean isCompletedThreadsErrorsEnabled() {
        return this.completedThreadsErrorsEnabled;
    }

    public void setCompletedThreadsErrorsEnabled(boolean completedThreadsErrorsEnabled) {
        this.completedThreadsErrorsEnabled = completedThreadsErrorsEnabled;
    }

    public long getMinCodeTraceTimeMillis() {
        return this.minCodeTraceTimeMillis;
    }

    public void setMinCodeTraceTimeMillis(long minCodeTraceTimeMillis) {
        this.minCodeTraceTimeMillis = minCodeTraceTimeMillis;
    }

    public ThreadProfileFilter getCompletedThreadsFilter() {
        return this.completedThreadsFilter;
    }

    public void setCompletedThreadsFilter(ThreadProfileFilter completedThreadsFilter) {
        this.completedThreadsFilter = completedThreadsFilter;
    }

    @PostConstruct
    public void start() {
        if (this.runOnStart) {
            this.turnOn();
        }
    }

    @PreDestroy
    public void shutdown() {
        this.turnOff();
    }

    public void turnOn() {
        if (!this.running) {
            this.running = true;
            this.profilerThread = new Thread((Runnable)this, "Profiler thread");
            this.profilerThread.setPriority(10);
            this.profilerThread.setDaemon(true);
            this.profilerThread.start();
        }
    }

    public void turnOff() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.dumpStackTraces();
                Thread.sleep(this.idleTimeInMillis);
            }
            catch (Throwable e) {
                log.error("Error dumping stack traces.", e);
            }
        }
    }

    protected synchronized void dumpStackTraces() {
        long beginTime = System.currentTimeMillis();
        for (ThreadProfile activeThread : this.activeThreads) {
            activeThread.dumpStackTrace();
        }
        long timeSpent = System.currentTimeMillis() - beginTime;
        if (timeSpent > 100L) {
            log.warn(this.activeThreads.size() + " stack traces saved in more than 100ms: " + Chronometer.formatElapsedTime(timeSpent));
        }
    }

    public synchronized void removeAllThreads() {
        this.completedThreads.clear();
    }

    public synchronized void removeThread(ThreadProfile tp) {
        this.completedThreads.remove(tp);
    }

    public long getCompletedThreadsMinTimeMillis() {
        return this.completedThreadsMinTimeMillis;
    }

    public void setCompletedThreadsMinTimeMillis(long completedThreadsMinTimeMillis) {
        this.completedThreadsMinTimeMillis = completedThreadsMinTimeMillis;
    }

    public ThreadProfile createThreadProfile() {
        ThreadProfile threadProfile = new ThreadProfile();
        threadProfile.setMaxThreadDurationInMillis(this.maxThreadProfilingTimeMillis);
        threadProfile.setMaxStackTraceLength(this.maxThreadStackTraceLength);
        return threadProfile;
    }

    public synchronized ThreadProfile beginThreadProfile() {
        ThreadProfile existingT = this.getCurrentThreadProfile();
        if (existingT != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("CURRENT THREAD EXECUTION IN PROGRESS:\n").append(existingT.printContext());
            buf.append("CREATOR CALL: ").append(ThreadProfile.printStackTrace(existingT.getThread(), 30));
            buf.append("NEW THREAD REQUESTER: ").append(ThreadProfile.printStackTrace(Thread.currentThread(), 30));
            log.warn("\n! TRYING TO BEGIN A NEW THREAD OVER A CURRENT THREAD IN PROGRESS !\n" + buf.toString());
        }
        ThreadProfile newT = this.createThreadProfile();
        this.activeThreads.add(newT);
        this.currentThreadProfile.set(newT);
        newT.begin();
        newT.getCodeBlockInProgress().addRuntimeConstraint(this.lowMemoryConstraints);
        log.debug("Thread execution begin. Id=" + newT.getId() + " (active=" + this.activeThreads.size() + ")");
        return newT;
    }

    public synchronized ThreadProfile finishThreadProfile() {
        boolean target;
        ThreadProfile t = this.currentThreadProfile.get();
        t.end();
        this.currentThreadProfile.set(null);
        this.activeThreads.remove(t);
        log.debug("Thread end. Id=" + t.getId() + ", Duration=" + Chronometer.formatElapsedTime(t.getElapsedTime()) + ", Active=" + this.activeThreads.size());
        boolean slow = t.getElapsedTime() > this.completedThreadsMinTimeMillis;
        boolean failed = this.completedThreadsErrorsEnabled && "ERROR".equals(t.getState());
        boolean filterOn = this.completedThreadsFilter.getPropertyIds().length > 0;
        boolean filtered = filterOn && this.completedThreadsFilter.pass(t);
        boolean bl = target = !(filterOn && !filtered || !slow && !failed);
        if (target || t.isTargetThread()) {
            this.completedThreads.add(t);
            if (this.completedThreads.size() > this.completedThreadsMaxSize) {
                this.completedThreads.remove(0);
            }
        }
        return t;
    }

    public ThreadProfile getCurrentThreadProfile() {
        return this.currentThreadProfile.get();
    }

    public List<ThreadProfile> getActiveThreads() {
        return new ArrayList<ThreadProfile>(this.activeThreads);
    }

    public List<ThreadProfile> getCompletedThreads() {
        return new ArrayList<ThreadProfile>(this.completedThreads);
    }

    public List<ThreadProfile> getAllThreads() {
        ArrayList<ThreadProfile> result = new ArrayList<ThreadProfile>(this.activeThreads);
        result.addAll(this.completedThreads);
        return result;
    }

    public List<ThreadProfile> getFilteredThreads() {
        ArrayList<ThreadProfile> result = new ArrayList<ThreadProfile>();
        for (ThreadProfile thread : this.activeThreads) {
            if (!this.completedThreadsFilter.pass(thread)) continue;
            result.add(thread);
        }
        for (ThreadProfile thread : this.completedThreads) {
            if (!this.completedThreadsFilter.pass(thread)) continue;
            result.add(thread);
        }
        return result;
    }

    public ThreadProfile getThreadProfile(int hash) {
        for (ThreadProfile tp : this.getActiveThreads()) {
            if (tp.hashCode() != hash) continue;
            return tp;
        }
        for (ThreadProfile tp : this.getCompletedThreads()) {
            if (tp.hashCode() != hash) continue;
            return tp;
        }
        return null;
    }

    public String printThreadsSummaryReport() {
        List<ThreadProfile> activeTxs = this.getActiveThreads();
        List<ThreadProfile> completedTxs = this.getCompletedThreads();
        Collections.sort(activeTxs, ThreadProfileComparator.comparatorByBeginDate(false));
        Collections.sort(completedTxs, ThreadProfileComparator.comparatorByBeginDate(false));
        StringBuffer buf = new StringBuffer();
        if (!activeTxs.isEmpty()) {
            buf.append(activeTxs.size() - 1).append(" threads running.\n");
        }
        if (!completedTxs.isEmpty()) {
            buf.append(completedTxs.size()).append(" threads completed in more than " + Chronometer.formatElapsedTime(this.completedThreadsMinTimeMillis) + " each.\n");
        }
        buf.append("\n");
        for (ThreadProfile t : activeTxs) {
            if (t.getThread() != null && t.getThread() == Thread.currentThread()) continue;
            buf.append("RUNNING   ").append(t.getId()).append(", Elapsed time=");
            buf.append(Chronometer.formatElapsedTime(t.getElapsedTime()));
            buf.append(", Begin=").append(t.getBeginDate()).append("\n");
        }
        for (ThreadProfile t : completedTxs) {
            buf.append("COMPLETED ").append(t.getId()).append(", Elapsed time=");
            buf.append(Chronometer.formatElapsedTime(t.getElapsedTime()));
            buf.append(", Begin=").append(t.getBeginDate()).append(", End=").append(t.getEndDate()).append("\n");
        }
        return buf.toString();
    }

    public String printActiveThreadsReport() {
        List<ThreadProfile> txs = this.getActiveThreads();
        Collections.sort(txs, ThreadProfileComparator.comparatorByBeginDate(false));
        StringBuffer buf = new StringBuffer();
        buf.append("\n\n------------------ ACTIVE THREADS=").append(txs.size() - 1).append(" -----------------------------\n");
        for (ThreadProfile t : txs) {
            if (t.getThread() != null && t.getThread() == Thread.currentThread()) continue;
            buf.append("\n").append(t.printContext()).append("\n");
            buf.append("--------------------------------------------");
        }
        return buf.toString();
    }

    public String printCompletedThreadsReport(long ignoreTracesMillis, boolean showContext) {
        List<ThreadProfile> txs = this.getCompletedThreads();
        Collections.sort(txs, ThreadProfileComparator.comparatorByBeginDate(false));
        StringBuffer buf = new StringBuffer();
        buf.append("\n\n------------------ COMPLETED THREADS=").append(txs.size()).append(" -----------------------------\n");
        if (this.completedThreadsMinTimeMillis > 0L) {
            buf.append("Maximum run time expected=" + Chronometer.formatElapsedTime(this.completedThreadsMinTimeMillis) + ".\n");
        }
        if (ignoreTracesMillis > 0L) {
            buf.append("Ignoring traces lower than " + Chronometer.formatElapsedTime(ignoreTracesMillis) + ".\n");
        }
        for (ThreadProfile t : txs) {
            CodeBlockTraces rootCodeTraces = new CodeBlockTraces();
            rootCodeTraces.add(t.getRootCodeBlock());
            String threadTree = rootCodeTraces.printTree(ignoreTracesMillis, showContext, "\n", 0);
            if (StringUtils.isEmpty((String)threadTree)) continue;
            buf.append("\n").append(threadTree);
            buf.append("--------------------------------------------");
        }
        return buf.toString();
    }

    protected String getSubjectPrefix() {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            return "[" + localhost.getHostName() + "] ";
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    protected StringBuffer appendErrorReport(StringBuffer buffer, ErrorReport error) {
        CodeBlockTrace codeBlock = error.getCodeBlock();
        buffer.append("<h4>ERROR REPORT</h4>");
        buffer.append("<table border=\"0\" cellpadding=\"1\" cellspacing=\"2\">");
        buffer.append("<tr><td valign=\"top\" align=\"left\">");
        buffer.append(codeBlock.printContext(true, "</td><td valign=\"top\" align=\"left\">= ", "</td></tr><tr><td align=\"left\">", 0));
        buffer.append("</td></tr>");
        buffer.append("</table>");
        return buffer;
    }

    protected StringBuffer appendThreadContext(StringBuffer buffer, ThreadProfile tp) {
        buffer.append("<h4>THREAD&#39;S DETAILS</h4>");
        buffer.append("<table border=\"0\" cellpadding=\"1\" cellspacing=\"2\">");
        for (String propName : tp.getContextPropertyNames()) {
            if (tp.getContextProperty(propName) == null) continue;
            String propValue = tp.getContextProperty(propName).toString();
            buffer.append("<tr><td valign=\"top\" align=\"left\">").append(propName).append("</td>");
            buffer.append("<td valign=\"top\" align=\"left\">= ").append(propValue).append("</td></tr>");
        }
        buffer.append("</table>");
        return buffer;
    }

    protected StringBuffer appendServerSettings(StringBuffer buffer) {
        buffer.append("<h4>SERVER SETTINGS</h4>");
        buffer.append("<table border=\"0\" cellpadding=\"1\" cellspacing=\"2\">");
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            buffer.append("<tr><td align=\"left\">Host name</td>");
            buffer.append("<td align=\"left\">= ").append(localhost.getHostName()).append("</td></tr>");
            buffer.append("<tr><td align=\"left\">Host IP </td>");
            buffer.append("<td align=\"left\">= ").append(localhost.getHostAddress()).append("</td></tr>");
        }
        catch (UnknownHostException e) {
            buffer.append("<tr><td align=\"left\">Host name</td>");
            buffer.append("<td align=\"left\">= Unknown</td></tr>");
        }
        buffer.append("</table>");
        return buffer;
    }

    protected StringBuffer appendCopyright(StringBuffer buffer) {
        buffer.append(Application.lookup().getCopyright()).append("<br/>");
        return buffer;
    }
}

