/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.test;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang.StringUtils;

public class MavenProjectHelper {
    public static final String JAVA_FOLDER = "java";
    public static final String ROOT_DIR = "dashboard-builder";

    public static File getModuleDir(String moduleName) {
        File rootDir = MavenProjectHelper.getRootDir();
        if (rootDir == null) {
            throw new NullPointerException("Root directory not found");
        }
        List<File> javaFolders = MavenProjectHelper.getFolders(rootDir, (FileFilter)FileFilterUtils.nameFileFilter((String)moduleName));
        if (!javaFolders.isEmpty()) {
            return javaFolders.get(0);
        }
        throw new RuntimeException("Module " + moduleName + " dir not found. Root=" + rootDir.getPath());
    }

    public static File getRootDir() {
        File rootDir;
        for (rootDir = new File(System.getProperty("user.dir")); rootDir != null && !ROOT_DIR.equals(rootDir.getName()); rootDir = rootDir.getParentFile()) {
        }
        return rootDir;
    }

    public static Collection<String> getJavaPackages(File root) {
        HashSet<String> result = new HashSet<String>();
        List<File> folders = MavenProjectHelper.getSourceFolders(root);
        for (File folder : folders) {
            String fullPath = folder.getAbsolutePath();
            int index = fullPath.indexOf("/java/");
            if (index == -1) continue;
            String javaPath = fullPath.substring(index + 6);
            String javaPackage = StringUtils.replace((String)javaPath, (String)"/", (String)".");
            result.add(javaPackage);
        }
        return result;
    }

    public static List<File> getSourceFolders(File root) {
        List<File> javaFolders = MavenProjectHelper.getFolders(root, (FileFilter)FileFilterUtils.nameFileFilter((String)JAVA_FOLDER));
        ArrayList<File> result = new ArrayList<File>();
        for (File javaFolder : javaFolders) {
            List<File> _folders = MavenProjectHelper.getFolders(javaFolder, null);
            result.add(javaFolder);
            result.addAll(_folders);
        }
        return result;
    }

    public static List<File> getFolders(File root, FileFilter filter) {
        File[] files;
        ArrayList<File> result = new ArrayList<File>();
        if (root == null || !root.isDirectory()) {
            return result;
        }
        for (File file : files = root.listFiles()) {
            if (!file.isDirectory()) continue;
            if (filter == null || filter.accept(file)) {
                result.add(file);
            }
            result.addAll(MavenProjectHelper.getFolders(file, filter));
        }
        return result;
    }
}

