/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.message;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.jboss.dashboard.commons.message.Message;

public abstract class AbstractMessage
extends Exception
implements Message {
    protected Object[] elements;
    protected String messageCode;
    protected int messageType;

    public AbstractMessage(String messageCode, Object[] elements) {
        this.elements = elements;
        this.messageCode = messageCode;
        this.messageType = 5;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (this.getMessageType() != other.getMessageType()) {
            return false;
        }
        return this.getMessageCode().equals(other.getMessageCode());
    }

    @Override
    public Object[] getElements() {
        return this.elements;
    }

    @Override
    public void setElements(Object[] elements) {
        this.elements = elements;
    }

    @Override
    public String getMessageCode() {
        return this.messageCode;
    }

    @Override
    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }

    @Override
    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    @Override
    public String getMessage(Locale l) {
        StringBuffer messageStr = new StringBuffer(this.getMessage(this.messageCode, l));
        if (this.elements == null) {
            return messageStr.toString();
        }
        for (int i = 0; i < this.elements.length; ++i) {
            String elementStr;
            Object element = this.elements[i];
            if (element == null || (elementStr = this.toString(element, l)).equals("")) continue;
            if (i == 0) {
                messageStr.append(" ");
            }
            if (i > 0) {
                messageStr.append(", ");
            }
            messageStr.append(elementStr);
        }
        if (!messageStr.substring(messageStr.length() - 1).equals(".")) {
            messageStr.append(".");
        }
        return messageStr.toString();
    }

    public String toString(Object element, Locale l) {
        if (element == null) {
            return "";
        }
        if (element instanceof Collection) {
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            for (Object o : (Collection)element) {
                buf.append(this.toString(o, l)).append(" ");
            }
            buf.append("]");
            return buf.toString();
        }
        if (element instanceof Map) {
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            Map m = (Map)element;
            for (Map.Entry row : m.entrySet()) {
                buf.append(this.toString(row.getKey(), l)).append("=").append(this.toString(row.getValue(), l)).append(" ");
            }
            buf.append("]");
            return buf.toString();
        }
        return element.toString();
    }

    @Override
    public boolean isEditable() {
        return this.elements != null && this.elements.length > 0;
    }

    public abstract String getMessage(String var1, Locale var2);
}

