/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.dashboard.annotation.Startable;
import org.jboss.dashboard.commons.comparator.ComparatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartableProcessor {
    private static transient Logger log = LoggerFactory.getLogger((String)StartableProcessor.class.getName());
    @Inject
    protected Instance<Startable> startables;
    private static final Comparator<Startable> STARTABLE_COMPARATOR = new Comparator<Startable>(){

        @Override
        public int compare(Startable s1, Startable s2) {
            return ComparatorUtils.compare(Integer.valueOf(s1.getPriority().getWeight()), Integer.valueOf(s2.getPriority().getWeight()), -1);
        }
    };

    public void wakeUpStartableBeans() throws Exception {
        ArrayList<Startable> startableList = new ArrayList<Startable>();
        for (Startable startable : this.startables) {
            startableList.add(startable);
        }
        Collections.sort(startableList, STARTABLE_COMPARATOR);
        for (Startable startable : startableList) {
            try {
                log.debug("Starting " + (Object)((Object)startable.getPriority()) + " priority bean " + startable.getClass().getName());
                startable.start();
            }
            catch (Exception e) {
                log.error("Error starting bean " + startable.getClass().getName(), (Throwable)e);
            }
        }
    }
}

