/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.xml;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.xerces.util.XMLChar;
import org.jboss.dashboard.commons.text.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLNode
implements Serializable {
    private static transient Logger log = LoggerFactory.getLogger((String)XMLNode.class.getName());
    private String objectName;
    private Properties attributes;
    private List<XMLNode> children;
    private byte[] content;
    private List warnings;
    private List warningArguments;
    private XMLNode parent;

    public XMLNode(String objectName, XMLNode parent) {
        this.parent = parent;
        this.objectName = objectName;
        this.attributes = new Properties();
        this.children = new ArrayList<XMLNode>();
        this.warnings = new ArrayList();
        this.warningArguments = new ArrayList();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public List<XMLNode> getChildren() {
        return this.children;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public List getWarningArguments() {
        return this.warningArguments;
    }

    public XMLNode getParent() {
        return this.parent;
    }

    public Object addAttribute(String name, String value) {
        if (name != null) {
            if (value == null) {
                return this.attributes.remove(name);
            }
            return this.attributes.setProperty(name, value);
        }
        return null;
    }

    public void addChild(XMLNode node) {
        this.children.add(node);
    }

    public void addWarning(String warning, Object[] arguments) {
        this.warnings.add(warning);
        this.warningArguments.add(arguments);
    }

    public void addWarning(String warning, Object arguments) {
        this.warnings.add(warning);
        this.warningArguments.add(new Object[]{arguments});
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void writeXML(Writer writer, boolean blanks) throws IOException {
        writer.write(blanks ? "\n" : "");
        writer.write("<");
        writer.write(this.objectName);
        for (String string : this.attributes.keySet()) {
            String attributeValue = this.attributes.getProperty(string, "");
            writer.write(" " + string + "=\"" + XMLNode.escapeXml(attributeValue) + "\"");
        }
        if (this.children.isEmpty() && this.content == null) {
            writer.write("/>");
        } else {
            writer.write(">");
            for (XMLNode xMLNode : this.children) {
                xMLNode.writeXML(writer, blanks);
            }
            if (this.content != null) {
                writer.write(Base64.encode(this.content));
            } else {
                writer.write(blanks ? "\n" : "");
            }
            writer.write("</");
            writer.write(this.objectName);
            writer.write(">");
        }
        writer.flush();
    }

    public void loadFromXMLNode(Node node) {
        this.objectName = node.getNodeName();
        NamedNodeMap attributesMap = node.getAttributes();
        if (attributesMap != null) {
            for (int i = 0; i < attributesMap.getLength(); ++i) {
                Node attribute = attributesMap.item(i);
                this.addAttribute(attribute.getNodeName(), StringEscapeUtils.unescapeXml((String)attribute.getNodeValue()));
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("#text")) {
                String content = child.getNodeValue();
                if (content == null || content.trim().length() <= 0) continue;
                this.setContent(Base64.decode(child.getNodeValue().trim()));
                continue;
            }
            XMLNode childNode = new XMLNode("?", this);
            childNode.loadFromXMLNode(child);
            this.addChild(childNode);
        }
    }

    public static String escapeXml(String s) {
        s = StringEscapeUtils.escapeXml((String)s);
        StringBuffer dest = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!XMLChar.isValid((int)c)) continue;
            dest.append(c);
        }
        return dest.toString();
    }
}

