/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.i18n;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.dashboard.LocaleManager;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.test.ShrinkWrapHelper;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class L10nTest {
    public static final Locale LOCALE_ES = new Locale("es");
    public static final Locale LOCALE_ES_AR = new Locale("es", "AR");
    public static final String STRING1_EN = "String 1";
    public static final String STRING1_ES = "Texto 1";
    @Inject
    BeanManager beanManager;
    @Inject
    protected LocaleManager localeManager;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        CDIBeanLocator.beanManager = this.beanManager;
        this.localeManager.setDefaultLocaleId("en");
        this.localeManager.setInstalledLocaleIds(new String[]{"en", "es"});
    }

    @Test
    public void checkDefaultLocale() {
        this.localeManager.setDefaultLocale(Locale.ENGLISH);
        this.localeManager.init();
        Assertions.assertThat((boolean)this.localeManager.getDefaultLocale().equals(Locale.ENGLISH)).isTrue();
    }

    @Test
    public void checkUnsupportedLocale() {
        this.localeManager.setDefaultLocale(Locale.ITALY);
        this.localeManager.init();
        Assertions.assertThat((boolean)this.localeManager.getDefaultLocale().equals(Locale.ENGLISH)).isTrue();
    }

    @Test
    public void checkSupportedVariant() {
        this.localeManager.setDefaultLocale(Locale.UK);
        this.localeManager.init();
        Assertions.assertThat((boolean)this.localeManager.getDefaultLocale().equals(Locale.ENGLISH)).isTrue();
        ResourceBundle bundle = this.localeManager.getBundle("org.jboss.dashboard.i18n.l10ntest", this.localeManager.getDefaultLocale());
        String string1 = bundle.getString("string1");
        Assertions.assertThat((boolean)string1.equals(STRING1_EN));
    }

    @Test
    public void checkSupportedByDefault() {
        this.localeManager.setDefaultLocale(LOCALE_ES_AR);
        this.localeManager.init();
        Assertions.assertThat((boolean)this.localeManager.getDefaultLocale().equals(LOCALE_ES)).isTrue();
        ResourceBundle bundle = this.localeManager.getBundle("org.jboss.dashboard.i18n.l10ntest", this.localeManager.getDefaultLocale());
        String string1 = bundle.getString("string1");
        Assertions.assertThat((boolean)string1.equals(STRING1_ES));
    }
}

