/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.hibernate;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.UserType;
import org.jboss.dashboard.database.hibernate.LOBHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryBlobType
implements UserType,
Serializable {
    private static transient Logger log = LoggerFactory.getLogger((String)BinaryBlobType.class.getName());

    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return byte[].class;
    }

    public boolean equals(Object x, Object y) {
        return x == y || x != null && y != null && Arrays.equals((byte[])x, (byte[])y);
    }

    public int hashCode(Object o) throws HibernateException {
        return o == null ? 0 : o.hashCode();
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        LOBHelper.lookup().nullSafeSet(st, value, index, new LOBHelper.ValueWriter(){

            @Override
            public void writeValue(OutputStream os, Object value) throws IOException {
                if (value != null) {
                    os.write((byte[])value);
                }
            }

            @Override
            public void writeValue(PreparedStatement st, Object value, int index) throws SQLException {
                st.setBytes(index, (byte[])value);
            }
        });
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Object o;
        if (log.isDebugEnabled()) {
            log.debug("Getting value with names " + Arrays.asList(names));
        }
        if ((o = rs.getObject(names[0])) == null) {
            return null;
        }
        if (o instanceof Blob) {
            Blob blob = (Blob)o;
            if (blob == null) {
                return null;
            }
            return blob.getBytes(1L, (int)blob.length());
        }
        if (o instanceof byte[]) {
            return o;
        }
        throw new IllegalArgumentException("Unexpected value read. Must be Blob or byte[], but it is " + o.getClass());
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = (byte[])value;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object o) throws HibernateException {
        if (o == null) {
            return null;
        }
        byte[] b = (byte[])o;
        return b;
    }

    public Object assemble(Serializable serializable, Object owner) throws HibernateException {
        return serializable;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        if (original == null) {
            return null;
        }
        byte[] copy = new byte[((byte[])original).length];
        System.arraycopy(original, 0, copy, 0, copy.length);
        return copy;
    }
}

