/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.profiler;

import org.jboss.dashboard.commons.comparator.AbstractComparatorByCriteria;
import org.jboss.dashboard.commons.comparator.ComparatorUtils;
import org.jboss.dashboard.profiler.ThreadProfile;

public class ThreadProfileComparator
extends AbstractComparatorByCriteria {
    public static final String BEGIN_DATE = "beginDate";
    public static final String END_DATE = "endDate";
    public static final String ELAPSED_TIME = "elapsedTime";

    public static ThreadProfileComparator comparatorByBeginDate(boolean ascending) {
        ThreadProfileComparator c = new ThreadProfileComparator();
        c.addSortCriteria(BEGIN_DATE, ascending ? 1 : -1);
        return c;
    }

    public static ThreadProfileComparator comparatorByElapsedTime(boolean ascending) {
        ThreadProfileComparator c = new ThreadProfileComparator();
        c.addSortCriteria(ELAPSED_TIME, ascending ? 1 : -1);
        return c;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof ThreadProfile)) {
            return 1;
        }
        if (!(o2 instanceof ThreadProfile)) {
            return -1;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        ThreadProfile entry1 = (ThreadProfile)o1;
        ThreadProfile entry2 = (ThreadProfile)o2;
        for (Object[] criteriaProps : this.sortCriterias) {
            int compById;
            String criteriaId = (String)criteriaProps[0];
            int ordering = (Integer)criteriaProps[1];
            if (criteriaId.equals(BEGIN_DATE)) {
                compById = ComparatorUtils.compare(entry1.getBeginDate(), entry2.getBeginDate(), ordering);
                if (compById == 0) continue;
                return compById;
            }
            if (criteriaId.equals(END_DATE)) {
                compById = ComparatorUtils.compare(entry1.getEndDate(), entry2.getEndDate(), ordering);
                if (compById == 0) continue;
                return compById;
            }
            if (criteriaId.equals(ELAPSED_TIME)) {
                compById = ComparatorUtils.compare(Long.valueOf(entry1.getElapsedTime()), Long.valueOf(entry2.getElapsedTime()), ordering);
                if (compById == 0) continue;
                return compById;
            }
            int compByProp = ComparatorUtils.compare(entry1.getContextProperty(criteriaId), entry2.getContextProperty(criteriaId), ordering);
            if (compByProp == 0) continue;
            return compByProp;
        }
        return 0;
    }
}

