/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.export;

import java.io.InputStream;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.database.DataSourceEntry;
import org.jboss.dashboard.database.JDBCDataSourceEntry;
import org.jboss.dashboard.database.JNDIDataSourceEntry;
import org.jboss.dashboard.export.DataSourceImportManager;
import org.jboss.dashboard.export.InvalidDataSourceDefinition;
import org.jboss.dashboard.test.ShrinkWrapHelper;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Arquillian.class)
public class DataSourceImportManagerTest {
    private static transient Logger log = LoggerFactory.getLogger((String)DataSourceImportManagerTest.class.getName());
    @Inject
    BeanManager beanManager;
    @Inject
    protected DataSourceImportManager dataSourceImportManager;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        CDIBeanLocator.beanManager = this.beanManager;
    }

    @Test
    public void testCreateJNDIDatasource() throws Exception {
        InputStream dataStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jboss/dashboard/export/datasource-jndi.properties");
        DataSourceEntry entry = this.dataSourceImportManager.doImport(dataStream);
        Assertions.assertThat((Object)entry).isExactlyInstanceOf(JNDIDataSourceEntry.class);
        Assertions.assertThat((String)entry.getName()).isEqualToIgnoringCase("Test JNDI datasource");
        Assertions.assertThat((String)entry.getJndiPath()).isEqualToIgnoringCase("java:/comp/env/MyDSTest");
        Assertions.assertThat((String)entry.getTestQuery()).isEqualToIgnoringCase("select 1;");
    }

    @Test
    public void testCreateJNDIInvalidDatasource() throws Exception {
        InputStream dataStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jboss/dashboard/export/datasource-jndi-invalid.properties");
        try {
            DataSourceEntry entry = this.dataSourceImportManager.doImport(dataStream);
            Assertions.failBecauseExceptionWasNotThrown(InvalidDataSourceDefinition.class);
        }
        catch (InvalidDataSourceDefinition invalidDataSourceDefinition) {
            // empty catch block
        }
    }

    @Test
    public void testCreateJDBCDatasource() throws Exception {
        InputStream dataStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jboss/dashboard/export/datasource-jdbc.properties");
        DataSourceEntry entry = this.dataSourceImportManager.doImport(dataStream);
        Assertions.assertThat((Object)entry).isExactlyInstanceOf(JDBCDataSourceEntry.class);
        Assertions.assertThat((String)entry.getName()).isEqualToIgnoringCase("Test JDBC datasource");
        Assertions.assertThat((String)entry.getUrl()).isEqualToIgnoringCase("jdbc:h2:tcp://localhost/~/temp/test");
        Assertions.assertThat((String)entry.getDriverClass()).isEqualToIgnoringCase("org.h2.SomeDriverClass");
        Assertions.assertThat((String)entry.getUserName()).isEqualToIgnoringCase("user1");
        Assertions.assertThat((String)entry.getPassword()).isEqualToIgnoringCase("password1");
        Assertions.assertThat((String)entry.getTestQuery()).isEqualToIgnoringCase("select 1;");
    }

    @Test
    public void testCreateJDBCInvalidDatasource() throws Exception {
        InputStream dataStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jboss/dashboard/export/datasource-jdbc-invalid.properties");
        try {
            DataSourceEntry entry = this.dataSourceImportManager.doImport(dataStream);
            Assertions.failBecauseExceptionWasNotThrown(InvalidDataSourceDefinition.class);
        }
        catch (InvalidDataSourceDefinition invalidDataSourceDefinition) {
            // empty catch block
        }
    }
}

