/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.security.password;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.commons.security.cipher.PBEWithMD5AndDESCipher;

@ApplicationScoped
@Named(value="passwordObfuscator")
public class PasswordObfuscator {
    @Inject
    @Config(value="true")
    protected boolean enabled;
    @Inject
    @Config(value="OBF:")
    protected String prefix;
    protected PBEWithMD5AndDESCipher cipher = new PBEWithMD5AndDESCipher();

    public static PasswordObfuscator lookup() {
        return (PasswordObfuscator)CDIBeanLocator.getBeanByName("passwordObfuscator");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public PBEWithMD5AndDESCipher getCipher() {
        return this.cipher;
    }

    public void setCipher(PBEWithMD5AndDESCipher cipher) {
        this.cipher = cipher;
    }

    public boolean isObfuscated(String password) {
        return password.startsWith(this.prefix);
    }

    public String obfuscate(String password) {
        try {
            if (!this.isEnabled() || this.isObfuscated(password)) {
                return password;
            }
            String obfPwd = this.cipher.encrypt(password);
            return this.prefix + obfPwd;
        }
        catch (Exception e) {
            e.printStackTrace();
            return password;
        }
    }

    public String deobfuscate(String password) {
        try {
            if (!this.isObfuscated(password)) {
                return password;
            }
            String obfPwd = password.substring(this.prefix.length());
            return this.cipher.decrypt(obfPwd);
        }
        catch (Exception e) {
            e.printStackTrace();
            return password;
        }
    }
}

