/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.profiler;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.dashboard.commons.misc.Chronometer;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.CodeBlockType;

public class CodeBlockTraces {
    protected LinkedList<CodeBlockTrace> codeBlockList = new LinkedList();
    protected CodeBlockTrace max;
    protected CodeBlockTrace min;
    protected long selfTimeMillis = 0L;
    protected long elapsedTimeMillis = 0L;

    public int size() {
        return this.codeBlockList.size();
    }

    public void addAll(CodeBlockTraces s) {
        if (s == null) {
            return;
        }
        for (CodeBlockTrace trace : s.codeBlockList) {
            this.add(trace);
        }
    }

    public void add(CodeBlockTrace trace) {
        this.codeBlockList.add(trace);
        long self = trace.getSelfTimeMillis();
        long elapsed = trace.getElapsedTimeMillis();
        this.selfTimeMillis += self;
        this.elapsedTimeMillis += elapsed;
        this.max = null;
        this.min = null;
    }

    public void remove(CodeBlockTrace trace) {
        this.codeBlockList.remove(trace);
        long self = trace.getSelfTimeMillis();
        long elapsed = trace.getElapsedTimeMillis();
        this.selfTimeMillis -= self;
        this.elapsedTimeMillis -= elapsed;
        this.max = null;
        this.min = null;
    }

    public long getSelfTimeMillis() {
        return this.selfTimeMillis;
    }

    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public void setElapsedTimeMillis(long elapsedTimeMillis) {
        this.elapsedTimeMillis = elapsedTimeMillis;
    }

    public long getAverageTimeMillis() {
        if (this.size() > 0) {
            return this.selfTimeMillis / (long)this.size();
        }
        return 0L;
    }

    public CodeBlockTrace get(int index) {
        return this.codeBlockList.get(index);
    }

    public CodeBlockTrace first() {
        if (this.codeBlockList.isEmpty()) {
            return null;
        }
        return this.codeBlockList.getFirst();
    }

    public CodeBlockTrace last() {
        if (this.codeBlockList.isEmpty()) {
            return null;
        }
        return this.codeBlockList.getLast();
    }

    public CodeBlockTrace max() {
        if (this.max == null) {
            for (CodeBlockTrace trace : this.codeBlockList) {
                if (this.max != null && trace.getSelfTimeMillis() <= this.max.getSelfTimeMillis()) continue;
                this.max = trace;
            }
        }
        return this.max;
    }

    public CodeBlockTrace min() {
        if (this.min == null) {
            for (CodeBlockTrace trace : this.codeBlockList) {
                if (this.min != null && trace.getSelfTimeMillis() >= this.min.getSelfTimeMillis()) continue;
                this.min = trace;
            }
        }
        return this.min;
    }

    public long getElapsedTimeMillis(CodeBlockType type, boolean excludeDescendants) {
        long total = 0L;
        for (CodeBlockTrace trace : this.codeBlockList) {
            if (type != null && (!trace.getType().equals(type) || excludeDescendants && trace.isDescendantOfType(type))) continue;
            total += trace.getElapsedTimeMillis();
        }
        return total;
    }

    public Map<CodeBlockType, CodeBlockTraces> groupByType() {
        LinkedHashMap<CodeBlockType, CodeBlockTraces> results = new LinkedHashMap<CodeBlockType, CodeBlockTraces>();
        for (CodeBlockTrace trace : this.codeBlockList) {
            CodeBlockType type = trace.getType();
            CodeBlockTraces traces = (CodeBlockTraces)results.get(type);
            if (traces == null) {
                traces = new CodeBlockTraces();
                results.put(type, traces);
            }
            traces.add(trace);
        }
        return results;
    }

    public Map<String, CodeBlockTraces> groupById() {
        HashMap<String, CodeBlockTraces> results = new HashMap<String, CodeBlockTraces>();
        for (CodeBlockTrace trace : this.codeBlockList) {
            String id = trace.getId();
            CodeBlockTraces traces = (CodeBlockTraces)results.get(id);
            if (traces == null) {
                traces = new CodeBlockTraces();
                results.put(id, traces);
            }
            traces.add(trace);
        }
        return results;
    }

    public String printTree(long ignoreTracesMillis, boolean showContext, String rowSeparator, int indent) {
        if (this.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        String start = "* ";
        String sep = " - ";
        for (int i = 0; i < this.size(); ++i) {
            String childrenTree;
            CodeBlockTraces children;
            CodeBlockTrace trace = this.get(i);
            long elapsedTime = trace.getElapsedTimeMillis();
            if (ignoreTracesMillis > 0L && elapsedTime < ignoreTracesMillis) continue;
            String traceTime = Chronometer.formatElapsedTime(elapsedTime);
            String traceDescr = trace.getDescription();
            if (traceDescr.length() > 60) {
                traceDescr = "..." + traceDescr.substring(traceDescr.length() - 60);
            }
            trace.printIndent(buf, indent);
            buf.append(start);
            if (trace.isRunning()) {
                buf.append("RUNNING ");
            }
            buf.append(traceTime).append(sep).append(trace.getType().getId()).append(sep).append(traceDescr).append(rowSeparator);
            if (showContext) {
                String traceContext = trace.printContext(false, "=", rowSeparator, indent + 1);
                buf.append(traceContext).append(rowSeparator);
            }
            if ((children = trace.getChildren()) == null || (childrenTree = children.printTree(ignoreTracesMillis, showContext, rowSeparator, indent + 1)) == null) continue;
            buf.append(childrenTree).append(rowSeparator);
        }
        return buf.toString();
    }
}

