/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.commons.io.DirectoriesScanner;
import org.jboss.dashboard.database.hibernate.HibernateInitializer;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DatabaseAutoSynchronizer {
    private static transient Logger log = LoggerFactory.getLogger((String)DatabaseAutoSynchronizer.class.getName());
    @Inject
    @Config(value="sql")
    protected String databaseConfigDir;
    @Inject
    @Config(value="dashb_installed_module")
    protected String installedModulesTable;
    @Inject
    @Config(value="DELIMITER //,//,DELIMITER ;,GO")
    protected String[] excludedScriptStatements;
    @Inject
    @Config(value="-- CUSTOM_DELIMITER")
    protected String customDelimiter;
    @Inject
    @Config(value="-- ENABLE_CUSTOM_DELIMITER")
    protected String customDelimiterEnabler;
    @Inject
    @Config(value="true")
    private boolean createDatabase;

    public void synchronize(HibernateInitializer hibernateInitializer) throws Exception {
        if (this.createDatabase) {
            String databaseName = hibernateInitializer.getDatabaseName();
            boolean tableExists = this.existsModulesTable(hibernateInitializer.getDefaultSchema());
            if (!tableExists) {
                this.createDatabase(databaseName);
            }
        }
    }

    protected void createDatabase(String databaseName) throws Exception {
        File[] sqlFiles;
        String sqlDir = Application.lookup().getBaseCfgDirectory() + File.separator + this.databaseConfigDir;
        HashMap<String, File> sqlFileMap = new HashMap<String, File>();
        DirectoriesScanner scanner = new DirectoriesScanner("sql");
        for (File sqlFile : sqlFiles = scanner.findFiles(new File(sqlDir))) {
            if (!sqlFile.getName().endsWith(databaseName + ".sql") || !Character.isDigit(sqlFile.getName().charAt(0))) continue;
            sqlFileMap.put(sqlFile.getName(), sqlFile);
        }
        ArrayList sqlFileNames = new ArrayList(sqlFileMap.keySet());
        Collections.sort(sqlFileNames);
        for (String sqlFileName : sqlFileNames) {
            File sqlFile;
            sqlFile = (File)sqlFileMap.get(sqlFileName);
            this.runSQLFile(sqlFile);
        }
    }

    protected void runSQLFile(File f) throws Exception {
        if (f.exists() && f.isFile()) {
            log.warn("Running file " + f.getName());
            BufferedReader reader = new BufferedReader(new FileReader(f));
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            this.runDDL(sb.toString());
        }
    }

    protected void runDDL(String ddl) throws Exception {
        String separator = ddl.startsWith(this.customDelimiterEnabler) ? this.customDelimiter : ";";
        String[] statements = this.splitString(ddl, separator);
        for (int i = 0; i < statements.length; ++i) {
            final String ddlStatement = this.removeComments(statements[i]).trim();
            if (ddlStatement.length() == 0 || ArrayUtils.contains((Object[])this.excludedScriptStatements, (Object)ddlStatement)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Running statement: " + ddlStatement);
            }
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    Work w = new Work(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void execute(Connection connection) throws SQLException {
                            try (Statement statement = null;){
                                statement = connection.createStatement();
                                statement.execute(ddlStatement);
                            }
                        }
                    };
                    session.doWork(w);
                    session.flush();
                }
            }.execute();
        }
    }

    private String[] splitString(String str, String delims) {
        if (str == null) {
            return null;
        }
        if (str.equals("") || delims == null || delims.length() == 0) {
            return new String[]{str};
        }
        Vector<String> v = new Vector<String>();
        int pos = 0;
        int newpos = str.indexOf(delims, pos);
        while (newpos != -1) {
            v.addElement(str.substring(pos, newpos));
            pos = newpos + delims.length();
            newpos = str.indexOf(delims, pos);
        }
        v.addElement(str.substring(pos));
        String[] s = new String[v.size()];
        int cnt = s.length;
        for (int i = 0; i < cnt; ++i) {
            s[i] = ((String)v.elementAt(i)).trim();
        }
        return s;
    }

    protected String removeComments(String ddlStatement) {
        StringBuffer sb = new StringBuffer();
        BufferedReader strreader = new BufferedReader(new StringReader(ddlStatement));
        String line = null;
        try {
            while ((line = strreader.readLine()) != null) {
                if (line.trim().startsWith("--")) continue;
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            log.error("Error: ", (Throwable)e);
        }
        return sb.toString().trim();
    }

    protected boolean existsModulesTable(final String default_schema) throws Exception {
        final boolean[] returnValue = new boolean[]{false};
        new HibernateTxFragment(true){

            @Override
            protected void txFragment(Session session) throws Exception {
                Work w = new Work(){

                    public void execute(Connection connection) throws SQLException {
                        DatabaseMetaData metaData = connection.getMetaData();
                        String schema = default_schema != null && default_schema.trim().length() > 0 ? default_schema : null;
                        returnValue[0] = metaData.getTables(null, schema, DatabaseAutoSynchronizer.this.installedModulesTable.toLowerCase(), null).next();
                        if (!returnValue[0]) {
                            returnValue[0] = metaData.getTables(null, schema, DatabaseAutoSynchronizer.this.installedModulesTable.toUpperCase(), null).next();
                        }
                    }
                };
                session.doWork(w);
            }
        }.execute();
        return returnValue[0];
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

