/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.domain;

import java.util.ArrayList;
import java.util.List;
import org.jboss.dashboard.DataProviderServices;
import org.jboss.dashboard.domain.Domain;
import org.jboss.dashboard.function.ScalarFunction;
import org.jboss.dashboard.provider.DataProperty;

public abstract class AbstractDomain
implements Domain {
    public static final String I18N_PREFFIX = "abstractDomain.";
    protected DataProperty property = null;
    protected int maxNumberOfIntervals = 10;
    protected List scalarFunctionsSupported = null;

    @Override
    public DataProperty getProperty() {
        return this.property;
    }

    @Override
    public void setProperty(DataProperty property) {
        this.property = property;
    }

    @Override
    public int getMaxNumberOfIntervals() {
        return this.maxNumberOfIntervals;
    }

    @Override
    public void setMaxNumberOfIntervals(int maxNumberOfIntervals) {
        this.maxNumberOfIntervals = maxNumberOfIntervals;
    }

    @Override
    public boolean isScalarFunctionSupported(String functionCode) {
        ScalarFunction function = DataProviderServices.lookup().getScalarFunctionManager().getScalarFunctionByCode(functionCode);
        if (function == null) {
            return false;
        }
        return this.isScalarFunctionSupported(function);
    }

    @Override
    public List getScalarFunctionsSupported() {
        if (this.scalarFunctionsSupported != null) {
            return this.scalarFunctionsSupported;
        }
        ArrayList<ScalarFunction> results = new ArrayList<ScalarFunction>();
        ScalarFunction[] sfs = DataProviderServices.lookup().getScalarFunctionManager().getAllScalarFunctions();
        for (int i = 0; i < sfs.length; ++i) {
            ScalarFunction sf = sfs[i];
            if (sf == null || !this.isScalarFunctionSupported(sf)) continue;
            results.add(sf);
        }
        return results;
    }

    public void setScalarFunctionsSupported(List scalarFunctionsSupported) {
        this.scalarFunctionsSupported = scalarFunctionsSupported;
    }

    @Override
    public Domain cloneDomain() {
        try {
            AbstractDomain clone = (AbstractDomain)super.clone();
            clone.scalarFunctionsSupported = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

