/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jboss.dashboard.LocaleManager;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.domain.Domain;
import org.jboss.dashboard.provider.DataFormatterRegistry;
import org.jboss.dashboard.provider.DataProperty;
import org.jboss.dashboard.provider.DataPropertyFormatter;

public class AbstractDataProperty
implements DataProperty {
    protected String id;
    protected Map nameI18nMap = new HashMap();
    protected DataSet dataSet = null;
    protected Domain domain = null;

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).toHashCode();
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.id == null) {
                return false;
            }
            AbstractDataProperty other = (AbstractDataProperty)obj;
            return this.id.equals(other.id);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public String getPropertyId() {
        return this.id;
    }

    @Override
    public void setPropertyId(String id) {
        this.id = id;
    }

    @Override
    public String getName(Locale l) {
        String name = (String)this.nameI18nMap.get(l);
        if (name != null) {
            return name;
        }
        LocaleManager lm = LocaleManager.lookup();
        name = (String)lm.localize(this.nameI18nMap);
        if (name != null) {
            return name;
        }
        DataPropertyFormatter df = DataFormatterRegistry.lookup().getPropertyFormatter(this.id);
        if (df != null) {
            return df.formatName(this, l);
        }
        return this.id;
    }

    @Override
    public void setName(String name, Locale l) {
        this.nameI18nMap.put(l, name);
    }

    @Override
    public DataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(Domain domain) {
        this.domain = domain;
        if (domain != null) {
            domain.setProperty(this);
        }
    }

    @Override
    public List getValues() {
        if (this.dataSet == null) {
            return new ArrayList();
        }
        return this.dataSet.getPropertyValues(this);
    }

    @Override
    public Map getNameI18nMap() {
        return this.nameI18nMap;
    }

    @Override
    public void setNameI18nMap(Map nameI18nMap) {
        this.nameI18nMap = nameI18nMap;
    }

    @Override
    public DataProperty cloneProperty() {
        try {
            AbstractDataProperty clone = (AbstractDataProperty)super.clone();
            clone.setDomain(this.domain.cloneDomain());
            clone.setNameI18nMap(new HashMap());
            for (Locale locale : this.nameI18nMap.keySet()) {
                String name = this.getName(locale);
                clone.setName(name, locale);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

