/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.dataset.profiler;

import java.lang.ref.WeakReference;
import org.jboss.dashboard.commons.misc.Chronometer;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.dataset.DataSetException;
import org.jboss.dashboard.profiler.RuntimeConstraint;

public class DataSetSortConstraints
implements RuntimeConstraint {
    protected WeakReference<DataSet> dataSetRef;
    protected long startTime;

    public DataSetSortConstraints(DataSet dataSet) {
        this.dataSetRef = new WeakReference<DataSet>(dataSet);
        this.startTime = System.currentTimeMillis();
    }

    public void validate() throws Exception {
        DataSet dataSet = (DataSet)this.dataSetRef.get();
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        long maxTime = dataSet.getDataProvider().getDataLoader().getMaxDataSetSortTimeInMillis();
        if (maxTime > 0L && elapsedTime > maxTime) {
            String time = Chronometer.formatElapsedTime((long)maxTime);
            throw new DataSetException("Data set sort time has been exceeded = " + time);
        }
    }
}

