/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.dataset;

import java.util.Locale;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.provider.DataFormatterRegistry;
import org.jboss.dashboard.provider.DataProperty;
import org.jboss.dashboard.provider.DataPropertyFormatter;

public class Assertions {
    public static void assertDataSetValue(DataSet dataSet, int x, int y, String expected) {
        Locale locale = Locale.ENGLISH;
        DataFormatterRegistry dataFormatterRegistry = DataFormatterRegistry.lookup();
        Object value = dataSet.getValueAt(x, y);
        DataProperty prop = dataSet.getPropertyByColumn(y);
        DataPropertyFormatter propFormatter = dataFormatterRegistry.getPropertyFormatter(prop.getPropertyId());
        String displayedValue = propFormatter.formatValue(prop, value, locale);
        if (!displayedValue.equals(expected)) {
            org.fest.assertions.api.Assertions.fail((String)("Data set value [" + x + "," + y + "] is different. " + "Column=\"" + prop.getPropertyId() + "\" " + "Actual=\"" + displayedValue + "\" Expected=\"" + expected + "\""));
        }
    }

    public static void assertDataSetValues(DataSet dataSet, String[][] expected, int index) {
        Locale locale = Locale.ENGLISH;
        DataFormatterRegistry dataFormatterRegistry = DataFormatterRegistry.lookup();
        org.fest.assertions.api.Assertions.assertThat((int)dataSet.getRowCount()).isGreaterThan(index);
        for (int i = index; i < expected.length; ++i) {
            String[] row = expected[i];
            for (int j = 0; j < row.length; ++j) {
                DataPropertyFormatter propFormatter;
                String displayedValue;
                Object dataSetValue = dataSet.getValueAt(i, j);
                DataProperty prop = dataSet.getPropertyByColumn(j);
                String expectedValue = row[j];
                if (expectedValue == null || (displayedValue = (propFormatter = dataFormatterRegistry.getPropertyFormatter(prop.getPropertyId())).formatValue(prop, dataSetValue, locale)).equals(expectedValue)) continue;
                org.fest.assertions.api.Assertions.fail((String)("Data set value [" + i + "," + j + "] is different. " + "Column=\"" + prop.getPropertyId() + "\" " + "Actual=\"" + displayedValue + "\" Expected=\"" + expectedValue + "\""));
            }
        }
    }
}

