/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.dataset.profiler;

import java.lang.ref.WeakReference;
import org.jboss.dashboard.commons.misc.Chronometer;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.dataset.DataSetException;
import org.jboss.dashboard.profiler.RuntimeConstraint;
import org.jboss.dashboard.profiler.memory.MemoryProfiler;
import org.jboss.dashboard.provider.DataProvider;

public class DataSetLoadConstraints
implements RuntimeConstraint {
    protected WeakReference<DataSet> dataSetRef;
    protected long startMemory;
    protected long startTime;

    public DataSetLoadConstraints(DataSet dataSet) {
        this.dataSetRef = new WeakReference<DataSet>(dataSet);
        MemoryProfiler memoryProfiler = MemoryProfiler.lookup();
        this.startMemory = memoryProfiler.getMemoryUsedInBytes();
        this.startTime = System.currentTimeMillis();
    }

    public void validate() throws Exception {
        DataSet dataSet = (DataSet)this.dataSetRef.get();
        DataProvider dataProvider = dataSet.getDataProvider();
        if (dataProvider == null) {
            return;
        }
        MemoryProfiler memoryProfiler = MemoryProfiler.lookup();
        long memoryUsed = memoryProfiler.getMemoryUsedInBytes() - this.startMemory;
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        long sizeInBytes = dataSet.sizeOf();
        long maxSize = dataProvider.getDataLoader().getMaxDataSetSizeInBytes();
        long maxTime = dataProvider.getDataLoader().getMaxDataSetLoadTimeInMillis();
        long maxMemUsed = dataProvider.getDataLoader().getMaxMemoryUsedInDataLoad();
        if (maxMemUsed > 0L && memoryUsed > maxMemUsed) {
            String total = MemoryProfiler.formatSize((long)maxMemUsed);
            throw new DataSetException("Data set load memory usage has been exceeded = " + total);
        }
        if (maxTime > 0L && elapsedTime > maxTime) {
            String time = Chronometer.formatElapsedTime((long)maxTime);
            throw new DataSetException("Data set load time has been exceeded = " + time);
        }
        if (maxSize > 0L && sizeInBytes > maxSize) {
            String size = MemoryProfiler.formatSize((long)maxSize);
            throw new DataSetException("Data set size in memory has been exceeded = " + size);
        }
    }
}

