/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.provider.csv;

import java.io.PrintWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.jboss.dashboard.export.AbstractDataLoaderXMLFormat;
import org.jboss.dashboard.provider.DataLoader;
import org.jboss.dashboard.provider.csv.CSVDataLoader;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSVDataLoaderXMLFormat
extends AbstractDataLoaderXMLFormat {
    public DataLoader parse(NodeList xmlNodes) throws Exception {
        for (int i = 0; i < xmlNodes.getLength(); ++i) {
            Node item = xmlNodes.item(i);
            if (!item.getNodeName().equals("csvprovider")) continue;
            CSVDataLoader loader = new CSVDataLoader();
            NodeList subNodes = item.getChildNodes();
            for (int j = 0; j < subNodes.getLength(); ++j) {
                item = subNodes.item(j);
                if (item.getNodeName().equals("csvSeparatedBy") && item.hasChildNodes()) {
                    loader.setCsvSeparatedBy(StringEscapeUtils.unescapeXml((String)item.getFirstChild().getNodeValue()));
                }
                if (item.getNodeName().equals("csvQuoteChar") && item.hasChildNodes()) {
                    loader.setCsvQuoteChar(StringEscapeUtils.unescapeXml((String)item.getFirstChild().getNodeValue()));
                }
                if (item.getNodeName().equals("csvEscapeChar") && item.hasChildNodes()) {
                    loader.setCsvEscapeChar(StringEscapeUtils.unescapeXml((String)item.getFirstChild().getNodeValue()));
                }
                if (item.getNodeName().equals("csvDatePattern") && item.hasChildNodes()) {
                    loader.setCsvDatePattern(StringEscapeUtils.unescapeXml((String)item.getFirstChild().getNodeValue()));
                }
                if (item.getNodeName().equals("csvNumberPattern") && item.hasChildNodes()) {
                    loader.setCsvNumberPattern(StringEscapeUtils.unescapeXml((String)item.getFirstChild().getNodeValue()));
                }
                if (!item.getNodeName().equals("fileURL") || !item.hasChildNodes()) continue;
                loader.setFileURL(StringEscapeUtils.unescapeXml((String)item.getFirstChild().getNodeValue()));
            }
            return loader;
        }
        return null;
    }

    public void format(DataLoader loader, PrintWriter out, int indent) throws Exception {
        CSVDataLoader csvLoader = (CSVDataLoader)loader;
        this.printIndent(out, indent++);
        out.println("<csvprovider>");
        this.printIndent(out, indent);
        out.print("<csvSeparatedBy>");
        out.print(StringEscapeUtils.escapeXml((String)csvLoader.getCsvSeparatedBy()));
        out.println("</csvSeparatedBy>");
        this.printIndent(out, indent);
        out.print("<csvQuoteChar>");
        out.print(StringEscapeUtils.escapeXml((String)csvLoader.getCsvQuoteChar()));
        out.println("</csvQuoteChar>");
        this.printIndent(out, indent);
        out.print("<csvEscapeChar>");
        out.print(StringEscapeUtils.escapeXml((String)csvLoader.getCsvEscapeChar()));
        out.println("</csvEscapeChar>");
        this.printIndent(out, indent);
        out.print("<csvDatePattern>");
        out.print(StringEscapeUtils.escapeXml((String)csvLoader.getCsvDatePattern()));
        out.println("</csvDatePattern>");
        this.printIndent(out, indent);
        out.print("<csvNumberPattern>");
        out.print(StringEscapeUtils.escapeXml((String)csvLoader.getCsvNumberPattern()));
        out.println("</csvNumberPattern>");
        this.printIndent(out, indent);
        out.print("<fileURL>");
        out.print(StringEscapeUtils.escapeXml((String)csvLoader.getFileURL()));
        out.println("</fileURL>");
        this.printIndent(out, --indent);
        out.println("</csvprovider>");
    }
}

