/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.command;

import java.util.Collections;
import java.util.List;
import org.jboss.dashboard.command.AbstractCommand;
import org.jboss.dashboard.commons.filter.FilterByCriteria;
import org.jboss.dashboard.commons.filter.SQLFilterByCriteria;

public class SQLConditionCommand
extends AbstractCommand {
    public static final String ARGUMENT_REQUIRED = "required";
    public static final String ARGUMENT_OPTIONAL = "optional";
    protected transient String filterPropertyId;
    protected transient List filterWhereStatement;

    public SQLConditionCommand(String name) {
        super(name);
    }

    public String execute() throws Exception {
        if (this.getArguments().size() < 3) {
            throw new IllegalArgumentException("[" + this.name + ", missing arguments]");
        }
        String requiredStr = this.getArgument(0);
        boolean isRequired = false;
        if (ARGUMENT_REQUIRED.equalsIgnoreCase(requiredStr)) {
            isRequired = true;
        } else if (ARGUMENT_OPTIONAL.equalsIgnoreCase(requiredStr)) {
            isRequired = false;
        } else {
            throw new IllegalArgumentException("[" + this.name + ", argument " + requiredStr + " is not allowed. Expected: required or optional]");
        }
        String sqlColumn = this.getArgument(1);
        if (sqlColumn == null || sqlColumn.trim().length() == 0) {
            throw new IllegalArgumentException("[" + this.name + ", argument sqlColumn cannot be empty]");
        }
        this.filterPropertyId = this.getArgument(2);
        if (this.filterPropertyId == null || this.filterPropertyId.trim().length() == 0) {
            throw new IllegalArgumentException("[" + this.name + ", argument filterPropertyId cannot be empty]");
        }
        if (this.dataFilter != null) {
            String[] filterProperties = this.dataFilter.getPropertyIds();
            for (int i = 0; i < filterProperties.length; ++i) {
                String filterProperty = filterProperties[i];
                if (!this.filterPropertyId.equals(filterProperty)) continue;
                SQLFilterByCriteria filter = new SQLFilterByCriteria((FilterByCriteria)this.dataFilter);
                this.filterWhereStatement = filter.SQL_getWhereClause(this.filterPropertyId, sqlColumn, false, true);
                return this.getPreparedStatementFragment();
            }
        }
        if (isRequired) {
            return "1 != 1";
        }
        return "1 = 1";
    }

    public boolean containsProperty(String propertyId) throws Exception {
        String arg = this.getArgument(2);
        return arg != null && arg.equals(propertyId);
    }

    public String getFilterPropertyId() {
        return this.filterPropertyId;
    }

    public String getPreparedStatementFragment() {
        if (this.filterWhereStatement == null) {
            return null;
        }
        return (String)this.filterWhereStatement.get(0);
    }

    public List getPreparedStatementParameters() {
        if (this.filterWhereStatement == null) {
            return Collections.EMPTY_LIST;
        }
        return this.filterWhereStatement.subList(1, this.filterWhereStatement.size());
    }
}

