/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.provider.sql;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.jboss.dashboard.LocaleManager;
import org.jboss.dashboard.annotation.Install;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.export.DataLoaderXMLFormat;
import org.jboss.dashboard.provider.DataLoader;
import org.jboss.dashboard.provider.DataProviderType;
import org.jboss.dashboard.provider.sql.SQLDataLoader;
import org.jboss.dashboard.provider.sql.SQLDataLoaderXMLFormat;

@Install
public class SQLDataProviderType
implements DataProviderType {
    public static final String UID = "sql";
    @Inject
    @Config(value="sql")
    protected String uid;
    @Inject
    protected LocaleManager localeManager;
    protected SQLDataLoaderXMLFormat xmlFormat = new SQLDataLoaderXMLFormat();

    public String getUid() {
        return this.uid;
    }

    public DataLoaderXMLFormat getXmlFormat() {
        return this.xmlFormat;
    }

    public String getDescription(Locale l) {
        ResourceBundle i18n = this.localeManager.getBundle("org.jboss.dashboard.provider.messages", l);
        return i18n.getString("provider.sql.description");
    }

    public DataLoader createDataLoader() {
        SQLDataLoader loader = new SQLDataLoader();
        loader.setDataProviderType(this);
        return loader;
    }
}

