/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.security;

import java.io.Serializable;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SessionScoped
public class SecurityCache
implements Serializable {
    private static transient Log log = LogFactory.getLog((String)SecurityCache.class.getName());
    private boolean cacheEnabled = true;
    private Map cacheMappings = new HashMap();
    private static long cacheReads = 0L;
    private static long cacheHits = 0L;

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public Boolean getValue(Permission perm, String action) {
        ++cacheReads;
        Map m = (Map)this.cacheMappings.get(perm);
        Boolean b = null;
        if (m == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Security cache miss: " + perm));
            }
        } else {
            b = (Boolean)m.get(action);
            if (b == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Security cache miss: " + perm));
                }
            } else {
                ++cacheHits;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Security cache hit: " + perm));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache success rate: " + cacheHits * 100L / cacheReads + "%"));
        }
        return b;
    }

    public void setValue(Permission perm, String action, boolean b) {
        HashMap<String, Boolean> m = (HashMap<String, Boolean>)this.cacheMappings.get(perm);
        if (m == null) {
            m = new HashMap<String, Boolean>();
            this.cacheMappings.put(perm, m);
        }
        m.put(action, b ? Boolean.TRUE : Boolean.FALSE);
    }

    public void clear() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Clearing security cache.");
        }
        this.cacheMappings.clear();
    }

    public static long getCacheHits() {
        return cacheHits;
    }

    public static long getCacheReads() {
        return cacheReads;
    }
}

