/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.security;

import java.lang.reflect.Constructor;
import java.security.Permission;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;

public class PermissionDescriptor {
    private static final transient Log log = LogFactory.getLog(PermissionDescriptor.class);
    private static final Class[] _prpalConstructorTypes = new Class[]{String.class};
    private static final Object[] _permConstructorsTypes = new Object[]{new Class[]{String.class, String.class}, new Class[]{String.class}, new Class[0]};
    private Long dbid = null;
    private String principalClass = null;
    private String principalName = null;
    private String permissionClass = null;
    private String permissionResource = null;
    private String permissionActions = null;
    private Boolean readonly = false;

    public PermissionDescriptor() {
    }

    public PermissionDescriptor(Principal prpal, Permission perm) {
        this();
        this.setPrincipal(prpal);
        this.setPermission(perm);
    }

    public String getItemClassName() {
        return PermissionDescriptor.class.getName();
    }

    public Long getDbid() {
        return this.dbid;
    }

    public void setDbid(Long id) {
        this.dbid = id;
    }

    public String getPrincipalClass() {
        return this.principalClass;
    }

    public void setPrincipalClass(String principalClass) {
        this.principalClass = principalClass;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public String getPermissionClass() {
        return this.permissionClass;
    }

    public void setPermissionClass(String permissionClass) {
        this.permissionClass = permissionClass;
    }

    public String getPermissionResource() {
        return this.permissionResource;
    }

    public void setPermissionResource(String permissionResource) {
        this.permissionResource = permissionResource;
    }

    public String getPermissionActions() {
        return this.permissionActions;
    }

    public void setPermissionActions(String permissionActions) {
        this.permissionActions = permissionActions;
    }

    public Boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(Boolean readonly) {
        this.readonly = readonly;
    }

    public Principal getPrincipal() throws InstantiationException {
        if (this.principalClass == null) {
            return null;
        }
        try {
            Class<?> prpalClass = Class.forName(this.principalClass);
            Constructor<?> constr = prpalClass.getConstructor(_prpalConstructorTypes);
            return (Principal)constr.newInstance(this.principalName);
        }
        catch (Exception exception) {
            throw new InstantiationException("Principal class not supported (" + this.principalClass + ").");
        }
    }

    public void setPrincipal(Principal prpal) {
        this.principalClass = null;
        this.principalName = null;
        if (prpal != null) {
            this.principalClass = prpal.getClass().getName();
            this.principalName = prpal.getName();
        }
    }

    public Permission getPermission() throws InstantiationException {
        if (this.permissionClass == null) {
            return null;
        }
        for (int i = 0; i < _permConstructorsTypes.length; ++i) {
            try {
                Class<?> permClass = Class.forName(this.permissionClass);
                Class[] constrTypes = (Class[])_permConstructorsTypes[i];
                Constructor<?> constr = permClass.getConstructor(constrTypes);
                Object[] constrParams = new Object[]{this.permissionResource, this.permissionActions};
                return (Permission)constr.newInstance(constrParams);
            }
            catch (Exception ignored) {
                log.error((Object)("Permission class not supported (" + this.permissionClass + ")."));
                continue;
            }
        }
        throw new InstantiationException("Permission class not supported (" + this.permissionClass + ").");
    }

    public void setPermission(Permission perm) {
        this.permissionClass = null;
        this.permissionResource = null;
        this.permissionActions = null;
        if (perm != null) {
            this.permissionClass = perm.getClass().getName();
            this.permissionResource = perm.getName();
            this.permissionActions = perm.getActions();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PermissionDescriptor)) {
            return false;
        }
        PermissionDescriptor that = (PermissionDescriptor)obj;
        if (this.permissionClass == null && that.permissionClass != null) {
            return false;
        }
        if (this.permissionResource == null && that.permissionResource != null) {
            return false;
        }
        if (this.principalClass == null && that.principalClass != null) {
            return false;
        }
        if (this.principalName == null && that.principalName != null) {
            return false;
        }
        if (this.permissionClass != null && !this.permissionClass.equals(that.permissionClass)) {
            return false;
        }
        if (this.permissionResource != null && !this.permissionResource.equals(that.permissionResource)) {
            return false;
        }
        if (this.principalClass != null && !this.principalClass.equals(that.principalClass)) {
            return false;
        }
        return this.principalName == null || this.principalName.equals(that.principalName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<PermissionDescriptor: ");
        sb.append(" idPermission: " + this.dbid);
        sb.append(" principalClass: " + this.principalClass);
        sb.append(" principalName: " + this.principalName);
        sb.append(" permissionClass: " + this.permissionClass);
        sb.append(" permissionResource: " + this.permissionResource);
        sb.append(" permissionActions: " + this.permissionActions);
        sb.append(" >");
        return sb.toString();
    }

    public boolean isPersistent() {
        return this.dbid != null;
    }

    public boolean save() throws Exception {
        final boolean isTransient = !this.isPersistent();
        new HibernateTxFragment(){

            protected void txFragment(Session session) throws Exception {
                if (isTransient) {
                    PermissionDescriptor.this.persist(0);
                } else {
                    PermissionDescriptor.this.persist(1);
                }
            }
        }.execute();
        return isTransient;
    }

    public boolean delete() throws Exception {
        if (!this.isPersistent()) {
            return false;
        }
        this.persist(2);
        return true;
    }

    protected void persist(final int op) throws Exception {
        new HibernateTxFragment(){

            protected void txFragment(Session session) throws Exception {
                switch (op) {
                    case 0: {
                        session.save((Object)PermissionDescriptor.this);
                        break;
                    }
                    case 1: {
                        session.update((Object)PermissionDescriptor.this);
                        break;
                    }
                    case 2: {
                        session.delete((Object)PermissionDescriptor.this);
                    }
                }
                session.flush();
            }
        }.execute();
    }
}

